package com.pcloud.book.skill.entity;

import com.pcloud.common.entity.BaseEntity;
import com.pcloud.contentcenter.resource.dto.ResourceOfficeItemDTO;
import com.pcloud.contentcenter.resource.dto.ResourcePdfItemDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("订阅回复")
public class PcloudSubReply extends BaseEntity {

    @ApiModelProperty("技能id")
    private Long pcloudSkillId;

    @ApiModelProperty("订阅回复类型：1成功，2取消,3未订阅提醒 ")
    private Integer subType;

    @ApiModelProperty("类型 1 文字 2 图片 3 链接 4应用 5素材")
    private Integer type;

    @ApiModelProperty("类型 1 文字 2 图片 3 链接 4应用 5素材")
    private Integer replyType;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("描述")
    private String description;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("应用或作品id")
    private Long serveId;

    @ApiModelProperty("应用或作品类型")
    private String serveType;

    @ApiModelProperty("资源id")
    private Long resourceId;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("应用或作品图片")
    private String servePic;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("应用或作品类型名称")
    private String serveTypeName;

    @ApiModelProperty("应用或作品类型编码")
    private String serveTypeCode;

    @ApiModelProperty("资源链接")
    private String resourceUrl;

    @ApiModelProperty("资源名称")
    private String resourceName;

    @ApiModelProperty("资源类型编码")
    private String resourceTypeCode;

    @ApiModelProperty("资源类型名称")
    private String resourceTypeName;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("文件大小")
    private Long fileSize;

    @ApiModelProperty("pdf转码后的单张图片集合")
    private List<ResourcePdfItemDTO> resourcePdfItems;

    @ApiModelProperty("文件转码后的单张图片集合")
    private List<ResourceOfficeItemDTO> resourceOfficeItemDTOs;

    @ApiModelProperty("未订阅提醒消息间隔时间（秒）")
    private Integer remindIntervalTime;

    @ApiModelProperty("未订阅发送订阅链接是否开启")
    private Integer subLinkConfirm;

    @ApiModelProperty("未订阅发送订阅链接介绍")
    private String subLinkIntroduce;
}
