package com.pcloud.book.timecontrol.facade.impl;

import com.pcloud.book.group.dto.UserSelectParamDTO;
import com.pcloud.book.timecontrol.biz.SelfPlanBiz;
import com.pcloud.book.timecontrol.dto.SelfPlanUserDto;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlan;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlanFeedback;
import com.pcloud.book.timecontrol.entity.TimeControlSelfPlanItem;
import com.pcloud.book.timecontrol.vo.AddTask4SelfPlan;
import com.pcloud.book.timecontrol.vo.CreateSelfPlanVO;
import com.pcloud.book.timecontrol.vo.SelfPlanVO;
import com.pcloud.book.timecontrol.vo.UpdateSelfPlanVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.wechatgroup.base.exception.WechatGroupBizException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RequestMapping("selfPlan")
@RestController("selfPlanFacade")
public class SelfPlanFacadeImpl {

    @Autowired
    private SelfPlanBiz selfPlanBiz;

    @ApiOperation("定制个性化服务-第一步")
    @PostMapping("createSelfPlan")
    ResponseDto<?> createSelfPlan(@RequestHeader String token, @RequestBody @Validated CreateSelfPlanVO createSelfPlanVO) {
        Integer id = selfPlanBiz.createSelfPlan(createSelfPlanVO);
        return new ResponseDto<>(id);
    }

    @ApiOperation("修改定制个性化服务-第一步")
    @PostMapping("updateSelfPlan")
    ResponseDto<?> updateSelfPlan(@RequestHeader String token, @RequestBody @Validated UpdateSelfPlanVO updateSelfPlanVO) {
        selfPlanBiz.updateSelfPlan(updateSelfPlanVO);
        return new ResponseDto<>();
    }

    @PostMapping("addTask4SelfPlan")
    @ApiOperation("定制个性化服务-添加服务内容")
    ResponseDto<?> addTask4SelfPlan(@RequestHeader String token, @RequestBody @Validated AddTask4SelfPlan addTask4SelfPlan) {
        selfPlanBiz.addTask4SelfPlan(addTask4SelfPlan);
        return new ResponseDto<>();
    }

    @ApiOperation("服务记录")
    @GetMapping("listSelfPlan")
    ResponseDto<?> listSelfPlan(@RequestHeader String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                @RequestParam(value = "serviceState", required = false) Integer serviceState) {
        PageBeanNew<SelfPlanVO> pageBeanNew = selfPlanBiz.listSelfPlan(currentPage, numPerPage, serviceState);
        return new ResponseDto<>(pageBeanNew);
    }

    @ApiOperation(value = "删除服务", httpMethod = "GET")
    @GetMapping("deleteSelfPlan")
    ResponseDto<?> deleteSelfPlan(@RequestHeader String token, @RequestParam Integer planId) {
        selfPlanBiz.deleteSelfPlan(planId);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "编辑方案内容", httpMethod = "POST")
    @PostMapping("editSelfPlanItems")
    ResponseDto<?> editSelfPlanItems(@RequestHeader String token, @RequestBody List<TimeControlSelfPlanItem> selfPlanItemList) {
        selfPlanBiz.editSelfPlanItems(selfPlanItemList);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取方案内容(平台端)", httpMethod = "GET")
    @GetMapping("getSelfPlanItems4Pcloud")
    ResponseDto<?> getSelfPlanItems4Pcloud(@RequestHeader String token, @RequestParam Integer planId) {
       return new ResponseDto<>( selfPlanBiz.getSelfPlanItems(planId));
    }

    @ApiOperation(value = "获取方案内容(客户端)", httpMethod = "GET")
    @GetMapping("getSelfPlanItems4Wechat")
    ResponseDto<?> getSelfPlanItems4Wechat(@RequestParam Integer planId) {
        return new ResponseDto<>(selfPlanBiz.getSelfPlanItems4Wechat(planId));
    }

    @ApiOperation(value = "新增反馈", httpMethod = "POST")
    @PostMapping("commitFeedback")
    ResponseDto<?> commitFeedback(@RequestBody List<TimeControlSelfPlanFeedback> selfPlanFeedbackList) {
        selfPlanBiz.commitFeedback(selfPlanFeedbackList);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取反馈", httpMethod = "GET")
    @GetMapping("getFeedbackByPlan")
    ResponseDto<?> getFeedbackByPlan(@RequestHeader String token, @RequestParam Integer planId) {
        return new ResponseDto<>(selfPlanBiz.getFeedbackByPlan(planId));
    }

    @ApiOperation(value = "个性化定制-用户列表查询", httpMethod = "POST")
    @PostMapping("listUser4SelfPlan")
    public ResponseDto<PageBeanNew<SelfPlanUserDto>> listUser4SelfPlan(
            @RequestHeader("token") String token, @RequestBody @ApiParam UserSelectParamDTO userSelectParamDTO) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == userSelectParamDTO || null == userSelectParamDTO.getCurrentPage() || null == userSelectParamDTO.getNumPerPage()) {
            throw new WechatGroupBizException(WechatGroupBizException.PARAM_IS_NULL, "缺少参数");
        }
        if (StringUtil.isEmpty(userSelectParamDTO.getRobotId())){
            throw new WechatGroupBizException(WechatGroupBizException.PARAM_IS_NULL, "请选择个人号");
        }
        PageBeanNew<SelfPlanUserDto> pageBeanNew = selfPlanBiz.listUser4SelfPlan(userSelectParamDTO);
        return new ResponseDto<>(pageBeanNew);
    }

    @ApiOperation(value = "提交评价", httpMethod = "POST")
    @PostMapping("commitEvaluate")
    ResponseDto<?> commitEvaluate(@RequestBody TimeControlSelfPlanFeedback selfPlanFeedback) {
        selfPlanBiz.commitEvaluate(selfPlanFeedback);
        return new ResponseDto<>();
    }


    @ApiOperation(value = "设置高级设置", httpMethod = "POST")
    @PostMapping("advancedSetting")
    ResponseDto<?> advancedSetting(@RequestHeader String token, @RequestBody TimeControlSelfPlan timeControlSelfPlan) {
        selfPlanBiz.advancedSetting(timeControlSelfPlan);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取高级设置", httpMethod = "GET")
    @GetMapping("getSelfPlanById")
    ResponseDto<?> getSelfPlanById(@RequestHeader String token, @RequestParam("planId") Integer planId) {
        TimeControlSelfPlan  timeControlSelfPlan = selfPlanBiz.getSelfPlanById(planId);
        return new ResponseDto<>(timeControlSelfPlan);
    }

    @ApiOperation(value = "获取反馈意见", httpMethod = "GET")
    @GetMapping("getFeedbackPage")
    ResponseDto<PageBeanNew<TimeControlSelfPlanFeedback>> getFeedbackPage(@RequestHeader String token, @RequestParam("planId") Integer planId,
                                                                          @RequestParam Integer currentPage, @RequestParam Integer numPerPage) {
        PageBeanNew<TimeControlSelfPlanFeedback>  timeControlSelfPlanPage = selfPlanBiz.getFeedbackPage(planId,currentPage,numPerPage);
        return new ResponseDto<>(timeControlSelfPlanPage);
    }

    @ApiOperation(value = "获取最近一个计划", httpMethod = "GET")
    @GetMapping(value = "getLatestPlan")
    ResponseDto<?> getLatestPlan(@RequestParam String wxId, @RequestParam(value = "planId", required = false) Integer planId){
        TimeControlSelfPlan selfPlan = selfPlanBiz.getLatestPlan(wxId, planId);
        return new ResponseDto<>(selfPlan);
    }
}
