package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockPrizeRecordDao;
import com.pcloud.book.weixinclock.entity.WeixinClockPrizeRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/23 17:32
 */
@Repository("weixinClockPrizeRecordDao")
public class WeixinClockPrizeRecordDaoImpl extends BaseDaoImpl<WeixinClockPrizeRecord> implements WeixinClockPrizeRecordDao {

    @Override
    public int deleteByWxUserId(String wxUserId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wxUserId",wxUserId);
        return super.sqlSessionTemplate.delete(getStatement("deleteByWxUserId"),paramMap);
    }

    @Override
    public WeixinClockPrizeRecord selectByWxUserIdAndAppId(String wxUserId, Long appId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wxUserId",wxUserId);
        paramMap.put("appId",appId);
        return super.sqlSessionTemplate.selectOne(getStatement("selectByWxUserIdAndAppId"),paramMap);
    }

    @Override
    public void updatePrizeTime(String userWxId, Long clockPrizeId, Integer grantNum) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wxUserId",userWxId);
        paramMap.put("appId",clockPrizeId);
        paramMap.put("grantNum",grantNum);
        super.sqlSessionTemplate.update(getStatement("updatePrizeTime"),paramMap);
    }

    @Override
    public List<WeixinClockPrizeRecord> getAllPrizeList(String wxUserId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("wxUserId",wxUserId);
        return super.sqlSessionTemplate.selectList(getStatement("getAllPrizeList"),paramMap);
    }
}
