package com.pcloud.book.weixinclock.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description 打卡成员
 * @date 2019/8/16 9:53
 */
public class WeixinClockMember extends BaseEntity {

    private static final long serialVersionUID = 4437962905235665251L;

    @ApiModelProperty("主键")
    private Long weixinClockMemberId;

    @ApiModelProperty("签到打卡标识")
    private Long weixinClockId;

    @ApiModelProperty("微信用户标识")
    private String wxUserId;

    @ApiModelProperty("群分类标识")
    private Long bookGroupClassifyId;

    @ApiModelProperty("群标识")
    private String wxGroupId;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("头像")
    private String headPic;

    @ApiModelProperty("打卡天数")
    private Integer allClockDay;

    @ApiModelProperty("分数(打卡得分加点赞得分)")
    private Integer score;

    @ApiModelProperty("微信用户ID")
    private Long wechatUserId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    public Long getWeixinClockMemberId() {
        return weixinClockMemberId;
    }

    public void setWeixinClockMemberId(Long weixinClockMemberId) {
        this.weixinClockMemberId = weixinClockMemberId;
    }

    public Long getWeixinClockId() {
        return weixinClockId;
    }

    public void setWeixinClockId(Long weixinClockId) {
        this.weixinClockId = weixinClockId;
    }

    public String getWxUserId() {
        return wxUserId;
    }

    public void setWxUserId(String wxUserId) {
        this.wxUserId = wxUserId;
    }

    public Long getBookGroupClassifyId() {
        return bookGroupClassifyId;
    }

    public void setBookGroupClassifyId(Long bookGroupClassifyId) {
        this.bookGroupClassifyId = bookGroupClassifyId;
    }

    public String getWxGroupId() {
        return wxGroupId;
    }

    public void setWxGroupId(String wxGroupId) {
        this.wxGroupId = wxGroupId;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getHeadPic() {
        return headPic;
    }

    public void setHeadPic(String headPic) {
        this.headPic = headPic;
    }

    public Integer getAllClockDay() {
        return allClockDay;
    }

    public void setAllClockDay(Integer allClockDay) {
        this.allClockDay = allClockDay;
    }

    public Integer getScore() {
        return score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "WeixinClockMember{" +
                "weixinClockMemberId=" + weixinClockMemberId +
                ", weixinClockId=" + weixinClockId +
                ", wxUserId='" + wxUserId + '\'' +
                ", bookGroupClassifyId=" + bookGroupClassifyId +
                ", wxGroupId='" + wxGroupId + '\'' +
                ", nickname='" + nickname + '\'' +
                ", headPic='" + headPic + '\'' +
                ", allClockDay=" + allClockDay +
                ", wechatUserId=" + wechatUserId +
                ", createTime=" + createTime +
                '}';
    }
}
