package com.pcloud.book.weixinclock.vo.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.weixinclock.dto.RankDto;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.vo.BaseVO;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Describe: 微信群打卡分享返回类
 * @Author: zhangdongwei
 * @Date: Create on 10:43 2019/10/29 0029
 */
@Data
@ApiModel("微信群打卡分享返回类")
public class DoShareResponseVO extends BaseVO {
    @ApiModelProperty("排名")
    private Integer rankNum;

    @ApiModelProperty("打卡成员微信号")
    private String wxUserId;

    @ApiModelProperty("昵称")
    private String nickname;

    @ApiModelProperty("头像")
    private String headPic;

    @ApiModelProperty("打卡次数")
    private Integer clockNum;

    @ApiModelProperty("获得的点赞数")
    private Integer praiseNum;

    @ApiModelProperty("开始打卡日期")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date startClockDate;

    @ApiModelProperty("今天日期")
    @JsonFormat(
            pattern = "MM/dd",
            timezone = "GMT+8"
    )
    private Date today;

    @ApiModelProperty("农历日期")
    private String lunar;

    @ApiModelProperty("干支日期")
    private String ganZhi;

    @ApiModelProperty("分享句子")
    private String shareWord;

    @ApiModelProperty("二维码链接")
    private String qrcodeUrl;

    @ApiModelProperty("标题")
    private String title;

    public static DoShareResponseVO valueFromRankDto(RankDto dto){
        DoShareResponseVO vo = new DoShareResponseVO();
        BeanUtils.copyProperties(dto, vo);
        return vo;
    }
}
