package com.pcloud.book.weixinclock.vo.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.weixinclock.entity.WeixinClockPraise;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.vo.BaseVO;
import com.pcloud.readercenter.wechat.entity.WechatUser;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * @Describe: 获取点赞用户列表返回vo
 * @Author: zhangdongwei
 * @Date: Create on 21:37 2019/11/11 0011
 */
@Data
@ApiModel("获取点赞用户列表返回vo")
public class ListPraiseUserResponseVO extends BaseVO {
    /**
     * 点赞用户id
     */
    private Long priseUserId;
    /**
     * 点赞用户头像
     */
    private String headPic;
    /**
     * 点赞用户昵称
     */
    private String userName;
    /**
     * 点赞时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date praiseTime;

    public static List<ListPraiseUserResponseVO> valueFromPraiseUser(List<WeixinClockPraise> weixinClockPraises, Map<Long, WechatUser> wechatUserMap){
        if (ListUtils.isEmpty(weixinClockPraises)){
            return new ArrayList<>();
        }
        List<ListPraiseUserResponseVO> vos = new ArrayList<>();
        for (WeixinClockPraise weixinClockPraise : weixinClockPraises){
            ListPraiseUserResponseVO vo = new ListPraiseUserResponseVO();
            vo.setPriseUserId(weixinClockPraise.getPraiseUserId());
            vo.setPraiseTime(weixinClockPraise.getUpdateTime());
            WechatUser wechatUser = wechatUserMap.get(weixinClockPraise.getPraiseUserId());
            if (null == wechatUser){
                vos.add(vo);
                continue;
            }
            vo.setUserName(wechatUser.getWechatUserNickname());
            vo.setHeadPic(wechatUser.getWechatUserHeadurl());
            vos.add(vo);
        }
        return vos;
    }
}
