package com.pcloud.common.dto;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @Describe: TODO
 * @Author: zhangdongwei
 * @Date: Create on 11:35 2019/7/24 0024
 */
@ApiModel("商城信息流信息dto")
public class StoreFlowInfoDto extends BaseDto {
    /**
     * 标识（appId/productId/bookGroupId）
     */
    @ApiModelProperty("标识(appId/productId/bookGroupId)")
    private Long originId;
    /**
     * 类型(APP/PRODUCT/BOOK_GROUP)
     */
    @ApiModelProperty("类型(APP/PRODUCT/BOOK_GROUP)")
    private String originType;
    /**
     * 具体类型编码
     */
    @ApiModelProperty("具体类型")
    private String typeCode;
    /**
     * 具体类型名称
     */
    private String typeName;
    /**
     * 标题
     */
    @ApiModelProperty("标题")
    private String title;
    /**
     * 封面图片
     */
    @ApiModelProperty("封面图片")
    private String coverImg;
    /**
     * 大图
     */
    @ApiModelProperty("大图")
    private String bigImg;
    /**
     * 价格
     */
    @ApiModelProperty("价格")
    private BigDecimal price;
    /**
     * 最早开始时间(MM-dd)
     */
    @ApiModelProperty("开始时间(MM-dd)")
    private String startDateBegin;
    /**
     * 最晚开始时间(MM-dd)
     */
    @ApiModelProperty("最晚开始时间(MM-dd)")
    private String startDateEnd;
    /**
     * 数量（应用、作品下的资源数量， 社群书的群数量，等）
     */
    @ApiModelProperty("数量（应用、作品下的资源数量， 社群书的群数量，等）")
    private Integer resourceNum;
    /**
     * 数量（资源的item数量，群的成员数量，等）
     */
    @ApiModelProperty("数量（资源的item数量，群的成员数量，等）")
    private Integer resourceItemNum;
    /**
     * 讲师
     */
    @ApiModelProperty("讲师")
    private String lecturer;
    /**
     * 讲师头像
     */
    @ApiModelProperty("讲师头像")
    private String lecturerImg;

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }
    
    public String getBigImg() {
        return bigImg;
    }
    
    public void setBigImg(String bigImg) {
        this.bigImg = bigImg;
    }
    
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }



    public Integer getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(Integer resourceNum) {
        this.resourceNum = resourceNum;
    }

    public Integer getResourceItemNum() {
        return resourceItemNum;
    }

    public void setResourceItemNum(Integer resourceItemNum) {
        this.resourceItemNum = resourceItemNum;
    }

    public String getLecturer() {
        return lecturer;
    }

    public void setLecturer(String lecturer) {
        this.lecturer = lecturer;
    }

    
    public String getTypeName() {
        return typeName;
    }
    
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    


    public String getLecturerImg() {
        return lecturerImg;
    }

    public void setLecturerImg(String lecturerImg) {
        this.lecturerImg = lecturerImg;
    }
    
    public String getStartDateBegin() {
        return startDateBegin;
    }
    
    public void setStartDateBegin(String startDateBegin) {
        this.startDateBegin = startDateBegin;
    }
    
    public String getStartDateEnd() {
        return startDateEnd;
    }
    
    public void setStartDateEnd(String startDateEnd) {
        this.startDateEnd = startDateEnd;
    }
    
    @Override
    public String toString() {
        return "StoreFlowInfoDto{" +
                "originId=" + originId +
                ", originType='" + originType + '\'' +
                ", typeCode='" + typeCode + '\'' +
                ", typeName='" + typeName + '\'' +
                ", title='" + title + '\'' +
                ", coverImg='" + coverImg + '\'' +
                ", bigImg='" + bigImg + '\'' +
                ", price=" + price +
                ", startDateBegin='" + startDateBegin + '\'' +
                ", startDateEnd='" + startDateEnd + '\'' +
                ", resourceNum=" + resourceNum +
                ", resourceItemNum=" + resourceItemNum +
                ", lecturer='" + lecturer + '\'' +
                ", lecturerImg='" + lecturerImg + '\'' +
                '}';
    }
}
