/**
 *
 */
package com.pcloud.common.utils.bean;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ListUtils;

import org.apache.commons.collections.MapUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author：songx
 * @date：2019年3月28日,下午2:47:41
 */
public class ResponesUtils {

    /**
     * 单个对象实例化
     *
     * @param object
     * @param clazz
     * @return
     * @author songx
     * @date 2019年1月14日, 下午7:32:35
     */
    public static <T> T object(Object object, Class<T> clazz) {
        if (object == null) {
            try {
                return clazz.newInstance();
            } catch (Exception e) {
            }
        }
        return BeanUtils.copy(object, clazz);
    }

    /**
     * 集合查询结果判断
     *
     * @param lists
     * @return
     */
    public static <T> List<T> list(List<T> lists) {
        if (!ListUtils.isEmpty(lists)) {
            return lists;
        }
        return Lists.newArrayList();
    }

    /**
     * map查询结果判断
     *
     * @param map
     * @return
     */
    public static <K, V> Map<K, V> map(Map<K, V> map) {
        if (!MapUtils.isEmpty(map)) {
            return map;
        }
        return Maps.newHashMap();
    }

    /**
     * list集合结果转换
     *
     * @param lists
     * @param clazz
     * @return
     * @author songx
     * @date 2019年4月23日, 下午4:13:19
     */
    public static <T> List<T> list(List<?> lists, Class<T> clazz) {
        if (ListUtils.isEmpty(lists)) {
            return new ArrayList<>();
        }
        return BeanUtils.copy(lists, clazz);
    }

    /**
     * 分页查询结果判断
     *
     * @param pageBean
     * @return
     */
    public static <T> PageBeanNew<T> pageBean(PageBeanNew<T> pageBean) {
        if (pageBean != null) {
            return pageBean;
        }
        return new PageBeanNew<T>(0, 15, 0, new ArrayList<>());
    }

    /**
     * 分页查询结果转换
     *
     * @param pageBean
     * @param clazz
     * @return
     * @author songx
     * @date 2019年4月23日, 下午4:03:11
     */
    public static <T> PageBeanNew<T> pageBean(PageBeanNew<?> pageBean, Class<T> clazz) {
        if (pageBean == null) {
            return new PageBeanNew<>(0, 15, 0, new ArrayList<>());
        }
        return pageBean(BeanUtils.copy(pageBean, clazz));
    }

}
