/**
 *
 */
package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.AviserBookInfoParam;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountAndAdviserIdDTO;
import com.pcloud.book.book.dto.BookCountByAdvisersDto;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookRequestVO;
import com.pcloud.book.book.dto.BookResourceStatisticsDTO;
import com.pcloud.book.book.dto.BookRightsSettingDTO;
import com.pcloud.book.book.dto.BookStatisticsResultDto;
import com.pcloud.book.book.dto.BookVarietyStatsDto;
import com.pcloud.book.book.dto.BookVarietyStatsRequestDto;
import com.pcloud.book.book.dto.MapResourceTotalCountDTO;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @描述：编辑推广书籍接口类
 * @作者：songx
 * @创建时间：2017年1月4日,下午7:57:04 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAdviserServiceCloud", path = "book/v1.0/bookAdviserService")
@Api(description = "编辑推广书籍内部服务")
public interface BookAdviserService {

    /**
     * 获取某个编辑3个月内新创建的图书
     * @param adviserId
     * @return
     * @throws BizException
     */
    @GetMapping(value = "/listByAdviserId")
    ResponseEntity<ResponseDto<List<BookDto>>> listByAdviserId(@RequestParam("adviserId") Long adviserId) throws BizException;

    @GetMapping("getXiaoRuiClassifyIdByBookId")
    ResponseEntity<ResponseDto<Long>> getXiaoRuiClassifyIdByBookId(@RequestParam("bookId") Long bookId,
                                                                   @RequestParam("channelId") Long channelId,
                                                                   @RequestParam("adviserId") Long adviserId) throws BizException;

    @GetMapping("getBookIsOpenProcess")
    ResponseEntity<ResponseDto<Integer>> getBookIsOpenProcess(@RequestParam("bookId") Long bookId,
                                                                   @RequestParam("channelId") Long channelId,
                                                                   @RequestParam("adviserId") Long adviserId) throws BizException;
    /**
     * 获取编辑的推广书籍总数
     *
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取编辑的推广书籍总数", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "adviserIds", value = "编辑id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/getCountByAdvisers", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BookAdviserDto>>> getCountByAdvisers(@RequestBody(required = false) List<Long> adviserIds)
            throws BizException;

    /**
     * 根据ISBN码获取书籍
     *
     * @param bookId
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "根据ISBN码获取书籍", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookAdviserDto>> getByIsbn(@RequestParam(value = "isbn", required = false) String isbn,
                                                          @RequestParam(value = "channelId", required = false) Long channelId) throws BizException;

    /**
     * @param bookId
     * @param channelId
     * @return
     * @throws BizException
     * @throws @author:     lihao
     * @Title: getMainAdviserId
     * @Description:根据图书信息获取主编辑ID
     * @return: Long
     * @date: 2017年7月12日 上午10:54:24
     */
    @ApiOperation(value = "根据图书信息获取主编辑ID", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getMainAdviserId", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Long>> getMainAdviserId(@RequestParam(value = "bookId", required = false) Long bookId,
                                                       @RequestParam(value = "channelId", required = false) Long channelId) throws BizException;

    /**
     * 创建默认图书与编辑的关系
     *
     * @param agentId 出版标识
     * @param adviserId 编辑标识
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "创建默认图书与编辑的关系", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/createDefaultBook", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Long>> createDefaultBook( @RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException;
    
    
    /**
     * 设置编辑图书使用模板
     *
     * @param bookAdviser 编辑图书实体
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "设置编辑图书使用模板", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookAdviser", value = "编辑图书实体", dataType = "BookAdviser", paramType = "body")})
    @RequestMapping(value = "/setBookTemplet", method = RequestMethod.GET)
    void setBookTemplet(@RequestBody BookAdviser bookAdviser) throws BizException;
    
    @PostMapping("listAdviserBookInfo")
    @ApiOperation("获取图书基本信息")
    ResponseEntity<ResponseDto<Map<String,AdviserBookInfoDTO>>> listAdviserBookInfo(@RequestBody AviserBookInfoParam AviserBookInfoParam) throws BizException ;

    @PostMapping("getBookCountByAdviserId")
    @ApiOperation("根据编辑ID获取图书数量")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookCountByAdvisersDto", value = "bookCountByAdvisersDto", dataType = "BookCountByAdvisersDto", paramType = "body")})
    ResponseEntity<ResponseDto<Map<Long, BookCountAndAdviserIdDTO>>> getBookCountByAdviserId(@RequestBody BookCountByAdvisersDto bookCountByAdvisersDto) throws BizException ;

    @GetMapping("refactorData")
    @ApiOperation("刷数据，请勿使用")
    ResponseEntity<ResponseDto<String>> refactorData(@RequestParam("parentId") Long parentId,
                                                     @RequestParam("originTempletId") Long originTempletId,
                                                     @RequestParam(value = "secondTempletId",required = false) Long secondTempletId) throws BizException ;

    @ApiOperation("获取书刊小睿品牌介绍页权益")
    @GetMapping("getBookRightsSetting")
    ResponseEntity<ResponseDto<BookRightsSettingDTO>>getBookRightsSetting(
            @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
            @RequestParam("adviserId") Long adviserId);

    @ApiOperation("获取书下资源总数（包括现代纸书、1V1、小睿、社群码）")
    @GetMapping("mapResourceTotalCount")
    ResponseEntity<ResponseDto<Map<String, BookResourceStatisticsDTO>>> mapResourceTotalCount(@RequestBody MapResourceTotalCountDTO mapResourceTotalCountDTO);

    @ApiOperation(value = "获取编辑做书品种数统计信息", httpMethod = "POST")
    @PostMapping("/getAdviserBookVarietyStats")
    ResponseEntity<ResponseDto<Map<Long, BookVarietyStatsDto>>> getAdviserBookVarietyStats(@RequestBody List<BookVarietyStatsRequestDto> requestDtos) throws BizException;

    @GetMapping("getBookCountByAgentId")
    @ApiOperation("根据出版ID获取图书数量")
    ResponseEntity<ResponseDto<Integer>> getBookCountByAgentId(@RequestParam("agentId") Long agentId) throws BizException;

    @GetMapping("getBookByBookIdAdviserIdChannelId")
    @ApiOperation("根据ID获取图书信息")
    ResponseEntity<ResponseDto<BookDto>> getBookByBookIdAdviserIdChannelId(@RequestParam("bookId") Long bookId,
                                                                                 @RequestParam("channelId") Long channelId,
                                                                                 @RequestParam("adviserId") Long adviserId);

    @GetMapping("getBookAppletByBookId")
    @ApiOperation("根据bookID获取小程序码")
    ResponseEntity<ResponseDto<BookAppletSceneDTO>> getBookAppletByBookId(@RequestParam("bookId") Long bookId,
                                                                                      @RequestParam("channelId") Long channelId,
                                                                                      @RequestParam("adviserId") Long adviserId);

    @PostMapping("getHasWxWorkCode")
    @ApiOperation("erp获取二维码下面配置了企业微信的二维码")
    ResponseEntity<ResponseDto<List<Long>>> getHasWxWorkCode(@RequestBody List<Long> sceneIds);

    @PostMapping("getHasResourceCode")
    @ApiOperation("erp获取配置了资源的Rays码")
    ResponseEntity<ResponseDto<List<Long>>> getHasResourceCode(@RequestBody List<Long> sceneIds);

    @GetMapping("getBookIdsByAgentId")
    @ApiOperation("根据agentId获取书籍id")
    void getBookIdsByAgentId(@RequestParam("agentId") Long agentId);

    @PostMapping("getBookRightsCount")
    @ApiOperation("获取权益数量")
    ResponseEntity<ResponseDto<Map<String, BookStatisticsResultDto>>> getBookRightsCount(@RequestBody List<BookRequestVO> requestVOS);

    @ApiOperation("是否开启书籍目录功能")
    @GetMapping("getBookIsOpenCatalog")
    ResponseEntity<ResponseDto<Integer>> getBookIsOpenCatalog(@RequestParam("bookId") Long bookId,
                                                              @RequestParam("channelId") Long channelId,
                                                              @RequestParam("adviserId") Long adviserId) throws BizException;

    @GetMapping("getAllAdviserBook")
    @ApiOperation("获取所有编辑书籍")
    ResponseEntity<ResponseDto<PageBeanNew<AdviserBookInfoDTO>>> getAllAdviserBook(@RequestParam("currentPage") Integer currentPage,
                                                                                       @RequestParam("numPerPage") Integer numPerPage);

    @PostMapping("getBookMapByAdviserBookIds")
    ResponseEntity<ResponseDto<Map<Long, BookDto>>> getBookMapByAdviserBookIds(@RequestBody List<Long> adviserBookIds);

    @ApiOperation("编辑是否有立项书")
    @GetMapping("hasApprovalBook4Adviser")
    ResponseEntity<ResponseDto<Boolean>> hasApprovalBook4Adviser(@RequestParam("adviserId") Long adviserId);
}
