package com.pcloud.book.cultivate.service;

import com.pcloud.book.copyright.dto.BookAuthInfoCountDTO;
import com.pcloud.book.copyright.dto.BookAuthTotalCountDTO;
import com.pcloud.book.copyright.dto.CheckUserAuthDTO;
import com.pcloud.book.cultivate.dto.NotifySendDTO;
import com.pcloud.book.cultivate.entity.AppletNotifySendDTO;
import com.pcloud.book.cultivate.entity.CultivateNotifySend;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @author lily
 * @date 2018/12/4 16:23
 */
@FeignClient(value = "pcloud-service-book", qualifier = "cultivateNotifyServiceCloud", path = "book/v1.0/cultivateNotifyService")
@Api(description = "小程序站内信")
public interface CultivateNotifyService {

    @ApiOperation(value = "批量插入发送小程序用户", httpMethod = "POST")
    @RequestMapping(value = "/batchSendMiniUser", method = RequestMethod.POST)
    void batchSendMiniUser(@RequestBody List<CultivateNotifySend> list) throws BizException;


    @ApiOperation(value = "小睿互助发送站内信消息", httpMethod = "POST")
    @RequestMapping(value = "sendAppletUserNotify", method = RequestMethod.POST)
    void sendAppletUserNotify(@RequestBody List<CultivateNotifySend> list) throws BizException;


    @ApiOperation(value = "小睿互助创建站内信消息", httpMethod = "POST")
    @RequestMapping(value = "createNotify4Question", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Long>> createNotify4Question(@RequestBody AppletNotifySendDTO newSendDTO)  throws BizException;

    @ApiOperation(value = "应用创建站内信消息", httpMethod = "POST")
    @RequestMapping(value = "createNotify4App", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Long>> createNotify4App(@RequestBody AppletNotifySendDTO newSendDTO)  throws BizException;


    @ApiOperation("发小程序消息")
    @PostMapping("sendNotifyToUser")
    ResponseEntity<ResponseDto<Long>> sendNotifyToUser(@RequestBody NotifySendDTO notifySendDTO);
}
