package com.pcloud.book.adnews.dao;

import com.pcloud.book.adnews.entity.AdNews;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface AdNewsDao extends BaseDao<AdNews> {

    List<AdNews> getNewsToSendBySetIdAndAdviser(Long adNewsSetId, Long adviserId, Integer top);

    /**
     * 获取自有公众号的需要发送的新闻
     * @param adNewsSetId
     * @param adviserId
     * @param top
     * @return
     */
    List<AdNews> getNewsToSendBySetIdAndAdviser4Own(Long adNewsSetId, Long adviserId, Integer top);

    /**
     * 根据标签匹配新闻————新闻标题
     * @param adNewsSetId
     * @param adviserId
     * @param beginTime
     * @param proLabelName
     * @param depLabelName
     * @param purLabelName
     * @param top
     * @return
     */
    List<AdNews> getNewsByLabelName(Long adNewsSetId, Long adviserId, String beginTime, String proLabelName, String depLabelName, String purLabelName, Integer top);

    /**
     * 根据标签匹配新闻————公众号名称
     * @param adNewsSetId
     * @param adviserId
     * @param beginTime
     * @param proLabelName
     * @param depLabelName
     * @param purLabelName
     * @param top
     * @return
     */
    List<AdNews> getNews4WechatByLabelName(Long adNewsSetId, Long adviserId, String beginTime, String proLabelName, String depLabelName, String purLabelName, Integer top);
}
