package com.pcloud.book.advertising.dto;

import com.pcloud.common.dto.BaseDto;

import java.util.List;

import lombok.Data;

/**
 * @描述：品牌方数据修改
 * @作者：zhuyajie
 * @创建时间：14:01 2020/4/16
 * @版本：1.0
 */
@Data
public class BrandDataParamDTO extends BaseDto {
    /**
     * 来源类型（BOOK/QRCODE/APP/PRODUCT）
     */
    private String fromType;
    /**
     * 书刊id
     */
    private Long bookId;
    /**
     * 编辑id
     */
    private Long adviserId;
    /**
     * 运营id
     */
    private Long channelId;
    /**
     * 二维码id
     */
    private Long sceneId;
    /**
     * 应用或作品id
     */
    private Long serveId;

    /**
     * 数据类型和数值
     */
    private List<BrandDataAddDTO> dataAddDTOS;
}
