package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletRecordSevenDayDao;
import com.pcloud.book.applet.dto.AppletRecordDTO;
import com.pcloud.book.applet.entity.AppletRecordSevenDay;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletRecordSevenDayDaoImpl
 * @Author zhuyajie
 * @Description 资源7天统计
 * @Date 2021/5/19 17:22
 * @Version 1.0
 **/
@Component
public class AppletRecordSevenDayDaoImpl extends BaseDaoImpl<AppletRecordSevenDay> implements AppletRecordSevenDayDao {
    @Override
    public void deleteBySourceType(Integer sourceType) {
        getSessionTemplate().delete(getStatement("deleteBySourceType"), sourceType);
    }

    @Override
    public List<AppletRecordDTO> getResourceByGrade4H5(Integer sourceType, List<Long> gradeLabelIds, Integer limit, Integer sourceFrom) {
        Map<String, Object> map = new HashMap<>();
        map.put("sourceType", sourceType);
        map.put("gradeLabelIds", gradeLabelIds);
        map.put("limit", limit);
        map.put("sourceFrom", sourceFrom);
        return getSessionTemplate().selectList(getStatement("getResourceByGrade4H5"), map);
    }
}
