package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * (ReadBookRecord)实体类
 *
 * @author makejava
 * @since 2021-02-04 18:17:00
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ReadBookRecord extends BaseEntity {

    private static final long serialVersionUID = 430043591368019316L;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("用户id")
    private Long wechatUserId;

    @ApiModelProperty("书籍id")
    private Long bookId;

    @ApiModelProperty("渠道id")
    private Long channelId;

    @ApiModelProperty("编辑id")
    private Long adviserId;

    @ApiModelProperty("访问开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("访问结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("本次访问持续时间")
    private Long recordTime;

    @ApiModelProperty("记录来源 默认0 小程序")
    private Integer recordSource;

    @ApiModelProperty("离开方式 默认0 主动离开 1 超时离开")
    private Integer leaveType;

}