/**
 * 
 */
package com.pcloud.book.book.biz;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.AdviserManageDto;
import com.pcloud.book.book.dto.AviserBookInfoParam;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountAndAdviserIdDTO;
import com.pcloud.book.book.dto.BookCountByAdvisersDto;
import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.dto.BookDataStatisticsDTO;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookQrcodeStatisticsDTO;
import com.pcloud.book.book.dto.BookRequestVO;
import com.pcloud.book.book.dto.BookResourceStatisticsDTO;
import com.pcloud.book.book.dto.BookRightsSettingDTO;
import com.pcloud.book.book.dto.BookStatisticsResultDto;
import com.pcloud.book.book.dto.BookVarietyStatsDto;
import com.pcloud.book.book.dto.BookVarietyStatsRequestDto;
import com.pcloud.book.book.dto.QrcodeStatisticsDTO;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.vo.AgentBookStatsDetailVO;
import com.pcloud.book.book.vo.BookServeInfo;
import com.pcloud.book.book.vo.BookServesListDTO;
import com.pcloud.book.book.vo.ErpAdviserBookVO;
import com.pcloud.book.book.vo.PcloudAdviserBookVO;
import com.pcloud.book.book.vo.QrCodeVO;
import com.pcloud.book.book.vo.request.RelateRaysBookApprovalVO;
import com.pcloud.book.group.dto.BookAppletSceneDTO;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.channelcenter.qrcode.vo.BookQrcodeVO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import org.springframework.data.domain.Page;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @描述：编辑管理书籍逻辑层接口
 * @作者：songx
 * @创建时间：2016年12月30日,下午5:21:22
 * @版本：1.0
 */
public interface BookAdviserBiz {


	List<BookDto> listByAdviserId(Long adviserId);
	/**
	 * 创建编辑管理书籍关系
	 * 
	 * @param bookAdviser 图书编辑关联实体类
	 * @throws BizException
	 */
	public void create(BookAdviser bookAdviser) throws BizException;

	/**
	 * 删除编辑和书籍的推广信息
	 * 
	 * @param bookId 图书标识
	 * @return
	 */
	public void deleteByBook(Long bookId) throws BizException;

	/**
	 * 批量删除编辑和书籍的推广信息
	 * 
	 * @param bookIds 图书标识列表
	 * @throws BizException
	 */
	public void deleteByBooks(List<Long> bookIds) throws BizException;

	/**
	 * 获取编辑和书籍的关系
	 * 
	 * @param bookAdviser 图书编关联实体类
	 * @return
	 * @throws BizException
	 */
	public BookAdviserDto getByAdviser(BookAdviser bookAdviser) throws BizException;

	/**
	 * 获取编辑和书籍的关系
	 */
	 BookAdviserDto getBase(Long bookId, Long channelId, Long adviserId) throws BizException;

	/**
	 * 统计编辑推广的图书总数
	 * 
	 * @param adviserIds 编辑标识列表
	 * @return
	 */
	public Map<Long, BookAdviserDto> getCountByAdvisers(List<Long> adviserIds) throws BizException;

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param isbn
	 * @param channelId 渠道标识
	 * @return
	 * @throws BizException
	 */
	BookAdviserDto getByIsbn(String isbn, Long channelId) throws BizException;

	/**
	 * 获取配置过书籍的编辑top1
	 * @param bookId 书籍标识
	 * @param channelId 渠道标识
	 * @return
	 */
	Long getAdviserTop1(Long bookId, Long channelId);
	
	/**
	 * 根据书籍和渠道删除书籍编辑关联信息
	 * 
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 * @return
	 */
	void deleteByBookAndChannel(Long bookId, Long channelId) throws BizException;

	/**
	 * 根据图书信息获取主编辑ID
	 * @param bookId 图书标识
	 * @param channelId 渠道标识
	 */
	public Long getMainAdviserId(Long bookId, Long channelId);	
	
	/**
	 * 编辑管理--获取编辑列表（平台端）
	 * @param bookId 图书标识
	 */
	public List<AdviserManageDto> getAdviserList(Long bookId);

	/**
	 * 编辑管理--删除副编辑
	 * @param bookAdvisers 图书编辑实体列表
	 */
	public void delViceAdviser(List<BookAdviser> bookAdvisers);

	/**
	 * 创建默认图书与编辑的关系
	 * @param channelId 运营标识
	 * @param adviserId 编辑标识
	 * @return
	 */
	public Long createDefaultBook(Long channelId, Long adviserId);

	/**
	 * 获取默认创建的图书
	 * @param channelId 渠道标识
	 * @param adviserId 编辑标识
	 * @return
	 */
	public BookAdviserDto getDefaultBook(Long channelId, Long adviserId);

	/**
	 * 出版社下编辑的所有书刊的数目
	 * @param agentId 出版标识
	 * @return
	 */
	public Integer getBookCount(Long agentId);

	/**
	 * 时代大屏用
	 */
	public Integer getBookCounts(List<Long> agentIds);

	/**
	 * 更新模板
	 */
	public void updateBookTemplet(Book book);

	/**
	 * 获取图书每日新增个数-出版
	 * @param agentId 出版标识
	 */
	public List<BookCountDto> listBookCountByDate4Agent(Long agentId);

	/**
	 *时代大屏用
	 */
	public List<BookCountDto> listBookCountByDate4Agents(List<Long> agentIds);

	/**
	 * 删除书籍（编辑端）
	 * @param bookId 图书标识
	 * @param adviserId 编辑标识
	 * @param channelId 渠道标识
	 */
	public void deleteBook4Adviser(Long bookId, Long adviserId, Long channelId);

	/**
	 * 恢复书籍-编辑 
	 * @param bookId 图书标识
	 * @param adviserId 编辑标识
	 * @param channelId 渠道标识
	 * @param templetId 模板标识
	 * @param secondTempletId 模板第二阶级标识
	 */
	public void recoverBook4Adviser(Long bookId, Long adviserId, Long channelId, Long templetId,Long secondTempletId, Long graLabelId, Long subLabelId,
									Long verLabelId, Long areaLabelId, Boolean recoverScene, Long thirdTempletId);

	/**
	 * 获取编辑的图书总数
	 * @param adviserId 编辑标识
	 * @return
	 */
	public CountDto getAdviserBookCount(Long adviserId);

	/**
	 * 设置图书使用模板
	 * @param bookAdviser 图书编辑关联实体
	 * @return
	 */
	public void setBookTemplet(BookAdviser bookAdviser);

	Map<String,AdviserBookInfoDTO> listAdviserBookInfo(AviserBookInfoParam aviserBookInfoParam);

	Map<Long, BookCountAndAdviserIdDTO> getBookCountByAdviserId(BookCountByAdvisersDto bookCountByAdvisersDto);

	void refactorData(Long parentId,Long originTempletId, Long secondTempletId);

    PageBeanNew<ErpAdviserBookVO> listAdviserBook4Erp(String isbn, String uniqueNumber, String adviserName, Long agentId, Integer currentPage, Integer numPerPage);

    /**
     * 设置书刊是否已下印状态
     * @param bookAdviser 图书编辑关联实体
     * @throws BizException
     */
    void setIsPrint(BookAdviser bookAdviser) throws BizException;

	/**
	 * 获取书刊小睿品牌介绍页权益
	 * @param bookId
	 * @param channelId
	 * @param adviserId
	 * @return
	 */
    BookRightsSettingDTO getBookRightsSetting(Long bookId, Long channelId, Long adviserId);
	/**
	 * 主编辑其中一本
	 * @param bookId
	 * @return
	 */
	BookAdviserDto getOneMainBook(Long bookId);

	/**
	 * 查询权益数量
	 */
	Map<String, BookStatisticsResultDto> getBookRightsCount(List<BookRequestVO> requestVOS);

    PageBeanNew<QrCodeVO> getQrList(Long bookId, Long adviserId, Long channelId,Integer type, Integer currentPage, Integer numPerPage);

	/**
	 * 获取书下资源总数（包括现代纸书、1V1、小睿、社群码）
	 * @param adviserIds
	 * @param bookIds
	 * @param channelIds
	 * @return
	 */
	Map<String, BookResourceStatisticsDTO> mapResourceTotalCount(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);

	/**
	 * 获取书刊统计数据（用户数、扫码量）【现代纸书和社群书的总和】
	 * @param adviserIds
	 * @param bookIds
	 * @param channelIds
	 * @return
	 */
	Map<String, BookDataStatisticsDTO> mapBookDataStatistics(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);

	/**
	 * 出版社下图书数量
	 * @author：zhuyajie
	 * @date：2020/7/29 10:48
	 *  * @param null
	 */
	Integer getBookCountByAgentAndTime(Long agentId, String startTime, String endTime);

	/**
	 * 获取书刊二维码统计数据
	 * @param adviserIds
	 * @param bookIds
	 * @param channelIds
	 * @return
	 */
	Map<String, BookQrcodeStatisticsDTO> mapBookQrcodeStatistics(List<Long> adviserIds, List<Long> bookIds, List<Long> channelIds);

	PageBeanNew<QrcodeStatisticsDTO> getBookQrcodeStatistics(Long adviserId, Long bookId, Long channelId, Integer currentPage, Integer numPerPage);

	/**
	 * 小睿数据看板-书刊品种数
	 * @author：zhuyajie
	 * @date：2020/8/25 11:31
	 *  * @param null
	 */
	Map<String,Object> getRayBookCountAndRate(Boolean showRate);

    Integer getIsRui(Long adviserId, Long bookId, Long channelId);

	PageBeanNew<PcloudAdviserBookVO> listAdviserBook4Pcloud(String keyword, Integer currentPage, Integer numPerPage);

	Map<String, BookAdviserDto> getBookInfoByBookIds(List<Long> bookIds, List<Long> adviserIds, List<Long> channelIds);

	BookAdviserDto getBookByBookIdAdviserId(Long bookId, Long adviserId);

	Map<Long,BookVarietyStatsDto> getAdviserBookVarietyStats(List<BookVarietyStatsRequestDto> requestDtos);

	PageBeanNew<AgentBookStatsDetailVO> getAgentBookStatsDetail(Long agentId, String name, Date startDate, Date endDate, Integer isRay, Integer currentPage, Integer numPerPage);

    void exportAgentBookStatsDetail(Long agentId, String name, Date startDate, Date endDate, Integer isRay);

    /**
     * 查书刊配套答案
     * @author：zhuyajie
     * @date：2020/11/4 14:46
     *  * @param null
     */
    List<BookServeDTO> getAnswerServesByBook(Long bookId, Long adviserId, Long channelId);

	/**
	 * 购书流程获取书籍基本信息
	 * @param bookId
	 * @param adviserId
	 * @param channelId
	 * @return
	 */
    BookDto getBookDetail4Buy(Long bookId, Long adviserId, Long channelId);

	/**
	 * 导出编辑书刊列表(ERP项目用)
	 */
	Map<String,Object> exportAdviserBook4Erp(String isbn, String uniqueNumber, String adviserName, Long agentId);

	/**
	 *扫公众号码是否推小程序链接
	 * @param bookId
	 * @param adviserId
	 * @param channelId
	 * @param isSendMiniUrl 0 关闭 1 打开
	 */
    void updateSendMiniUrlState(Long bookId, Long adviserId, Long channelId, Integer isSendMiniUrl);

	/**
	 *
	 * @param bookId
	 * @param channelId
	 * @param adviserId
	 * @return
	 */
	BookDto getBookByBookIdAdviserIdChannelId(Long bookId, Long channelId, Long adviserId);

	/**
	 *
	 * @param bookId
	 * @param channelId
	 * @param adviserId
	 * @return
	 */
	BookAppletSceneDTO getBookAppletByBookId(Long bookId, Long channelId, Long adviserId);

	/**
	 * 获取最近创建的编辑书
	 * @author：zhuyajie
	 * @date：2021/2/4 12:00
	 *  * @param null
	 */
	BookDto getLatestAdviserBookByIsbn(String isbn);

	/**
	 *erp获取二维码下面配置了企业微信的二维码
	 */
	List<Long> getHasWxWorkCode(List<Long> sceneIds);

	/**
	 * erp获取rays自有码下面是否配置了资源
	 * @param sceneIds
	 * @return
	 */
	List<Long> getHasResourceCode4Erp(List<Long> sceneIds);



	/**
	 * 根据agentId获取书籍id
	 * @param agentId
	 */
    void getBookIdsByAgentId(Long agentId);
    void getBookIdsByAgentIdAndMonth(Long agentId,int month);

	List<Long> getBooksByAgentToken(Long agentId, int index,int month);

	BookServeInfo listBookServes4Book(String cursor, Integer limit);

	/**
	 * 小睿书下面的书刊权益数量
	 */
	Map<Long,Integer> rightsCountByBookIds(List<Long> bookIds);

	/**
	 * 编辑端 - 分页获取图书下二维码列表
	 */
	PageBeanNew<BookQrcodeVO> qrList4AdviserBookNew(Long bookId, Long channelId, Long adviserId, String sceneName, Integer currentPage, Integer numPerPage);

	/**
	 * 更新开启书刊目录状态
	 * @author：zhuyajie
	 * @date：2021/4/7 15:17
	 *  * @param null
	 */
    void updateOpenCatalogState(Long bookId, Long adviserId, Long channelId, Integer isOpenCatalog);

	/**
	 * 获取所有数据
	 * @param currentPage
	 * @param numPerPage
	 * @return
	 */
    PageBeanNew<AdviserBookInfoDTO> getAllAdviserBook(Integer currentPage, Integer numPerPage);

	/**
	 * 获取编辑书刊
	 * @param adviserBookIds
	 * @return
	 */
	Map<Long, BookDto> getBookMapByAdviserBookIds(List<Long> adviserBookIds);

	void updateRaysField4Erp(List<RelateRaysBookApprovalVO> relateRaysBookList);

	/**
	 * 编辑是否有立项书
	 * @author：zhuyajie
	 * @date：2021/4/25 16:27
	 *  * @param null
	 */
	Boolean hasApprovalBook4Adviser(Long adviserId);

	/**
	 * 更新书籍手机号登录状态
	 * @param bookId
	 * @param adviserId
	 * @param channelId
	 * @param bookPhoneAuth
	 */
    void updateBookPhoneAuth(Long bookId, Long adviserId, Long channelId, Integer bookPhoneAuth);

	/**
	 * 获取手机号登录状态
	 * @param sceneId
	 * @param bookId
	 * @param adviserId
	 * @param channelId
	 * @return
	 */
	Integer getBookPhoneAuth(Long sceneId, Long bookId, Long adviserId, Long channelId);
}
