package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.BookRaysClassifyDao;
import com.pcloud.book.book.entity.BookRaysClassify;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("bookRaysClassifyDao")
public class BookRaysClassifyDaoImpl extends BaseDaoImpl<BookRaysClassify> implements BookRaysClassifyDao {

    @Override
    public Long getClassifyIdByBookTemplateId(Long bookTemplateId) {
        return this.getSqlSession().selectOne("getClassifyIdByBookTemplateId", bookTemplateId);
    }

    @Override
    public List<BookRaysClassify> getClassifyListByIds(List<Long> bookTemplateIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("bookTemplateIds",bookTemplateIds);
        return this.getSqlSession().selectList("getClassifyListByIds", map);
    }
}
