package com.pcloud.book.cultivate.dao;

import com.pcloud.book.cultivate.dto.CultivateNotifyDTO;
import com.pcloud.book.cultivate.dto.CultivateNotifyTypeDTO;
import com.pcloud.book.cultivate.entity.CultivateNotifySend;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface CultivateNotifySendDao extends BaseDao<CultivateNotifySend> {

    Long getFirstNoReadNotify(Long wechatUserId);

    void updateIsRead(Long wechatUserId, Long messageId);

    void updateShowHome(Long wechatUserId);

    List<CultivateNotifyTypeDTO> getNotify4Type(Long wechatUserId);

    List<CultivateNotifyDTO> getNotifyListByType(Long wechatUserId, Integer messageType,Integer currentPage,Integer numPerPage);

    List<CultivateNotifySend> getNotifySendsByType(Long wechatUserId, Integer messageType);

    List<Long> getSendUserIds(Long messageId,Integer currentPage,Integer numPerPage);

    Integer getSendUserCount(Long messageId);

    void clearExpireNotifies();
}
