package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.WxWorkTeacherDTO;
import com.pcloud.book.group.vo.WeworkTeacherBookBindPageVO;
import com.pcloud.book.group.vo.WeworkTeacherBookBindVO;
import com.pcloud.book.group.vo.WeworkTeacherVO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * WeworkTeacherBiz
 *
 * @author guiq
 * @version 1.0
 * @since 2020年9月7日
 */
public interface WeworkTeacherBiz {

    /**
     * 新增
     *
     * @param weworkTeacherVO VO
     * @return 主键ID
     */
    Long addWxworkTeacher(WeworkTeacherVO weworkTeacherVO);

    /**
     * 更新
     *
     * @param weworkTeacherVO VO
     * @return 主键ID
     */
    Long updateWxworkTeacher(WeworkTeacherVO weworkTeacherVO);

    /**
     * 分页查询
     *
     * @param name        真实姓名
     * @param isOpen      开启状态
     * @param teacherType 类型
     * @param currentPage 分页参数
     * @param numPerPage  分页参数
     * @return 分页结果
     */
    PageBeanNew<WeworkTeacherVO> getWxworkTeacherList(String name, Integer isOpen, Integer teacherType, Integer currentPage, Integer numPerPage);

    /**
     * 获取所有开启的
     * @return 所有结果
     * @param bookId
     */
    List<WeworkTeacherVO> queryAll(Long bookId);

    /**
     * 根据主键删除记录
     * @param id 主键ID
     */
    void deleteTeacherById(Long id);

    /**
     * 新增图书与客服老师绑定关系
     * @param bindVO VO
     */
    void bindBookWxworkTeacher(WeworkTeacherBookBindVO bindVO);

    /**
     * 删除图书与客服老师绑定关系
     * @param bookId VO
     */
    void deleteBookWxworkTeacher(Long bookId);

    /**
     * 分页获取绑定关系
     *
     * @param name
     * @param currentPage 分页参数
     * @param numPerPage 分页参数
     * @return 分页结果
     */
    PageBeanNew<WeworkTeacherBookBindPageVO> getBookWxworkTeacherList(String name, Integer currentPage, Integer numPerPage);
    /**
     * 随机获取一个客服老师微信二维码
     * @author：zhuyajie
     * @date：2020/12/7 15:14
     *  * @param null
     */
    String getOneTeacherQrcode();

    /**
     * 根据id获取企业微信客服
     * @param teacherIds
     * @return
     */
    Map<Long, WxWorkTeacherDTO> getWxWorkTeacherByIds(List<Long> teacherIds);

    /**
     * 根据id查老师
     * @author：zhuyajie
     * @date：2021/5/10 15:12
     *  * @param null
     */
    WeworkTeacherVO getWxworkTeacherById(Long id);

    /**
     * H5首页-客服老师
     * @author：zhuyajie
     * @date：2021/5/11 16:40
     *  * @param null
     */
    PageBeanNew<WeworkTeacherVO> getTeacherByGradeLabel4ResourcePage(Long gradeLabelId, Integer currentPage, Integer numPerPage);
}
