package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.GroupAnnouncementDao;
import com.pcloud.book.group.entity.GroupAnnouncement;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/24 16:06
 **/
@Component("groupAnnouncementDao")
public class GroupAnnouncementDaoImpl extends BaseDaoImpl<GroupAnnouncement> implements GroupAnnouncementDao {
    @Override
    public void updateContentById(String content, Long id) {
        Map<String, Object> paramMap = new HashMap();
        paramMap.put("content", content);
        paramMap.put("id", id);
        this.getSqlSession().update(this.getStatement("updateContentById"), paramMap);
    }

    @Override
    public List<String> getHasAnnGroupIdsByBookGroupId(Long bookGroupId) {
        return this.getSqlSession().selectList(this.getStatement("getHasAnnGroupIdsByBookGroupId"), bookGroupId);
    }

    @Override
    public GroupAnnouncement getByGroupBookId(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getByGroupBookId"), bookGroupId);
    }

    @Override
    public GroupAnnouncement getByClassifyId(Long classifyId) {
        return this.getSqlSession().selectOne(this.getStatement("getByClassifyId"), classifyId);
    }
}
