package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourceRecomManageDao;
import com.pcloud.book.group.entity.ResourceRecomManage;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourceRecomManageDaoImpl
 * @Author zhuyajie
 * @Description 推荐资源管理
 * @Date 2021/7/9 14:48
 * @Version 1.0
 **/
@Component
public class ResourceRecomManageDaoImpl extends BaseDaoImpl<ResourceRecomManage> implements ResourceRecomManageDao {


    @Override
    public void deleteByServe(Long serveId, String serveType, Integer sourceFrom) {
        Map<String, Object> map = new HashMap<>();
        map.put("serveId", serveId);
        map.put("sourceFrom", sourceFrom);
        map.put("serveType", serveType);
        getSessionTemplate().delete(getStatement("deleteByServe"), map);
    }

    @Override
    public Map<Long, ResourceRecomManage> mapResourceRecomManage(List<Long> serveIds, String serveType, Integer sourceFrom) {
        Map<String, Object> map = new HashMap<>();
        map.put("serveIds", serveIds);
        map.put("sourceFrom", sourceFrom);
        map.put("serveType", serveType);
        return getSessionTemplate().selectMap(getStatement("mapResourceRecomManage"), map, "serveId");
    }
}
