package com.pcloud.book.pcloudkeyword.set;

import com.alibaba.fastjson.JSON;
import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.book.consumer.app.AppConsr;
import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.consumer.content.ResourceConsr;
import com.pcloud.book.consumer.resource.ProductConsr;
import com.pcloud.book.consumer.wechatgroup.WechatGroupConsr;
import com.pcloud.book.group.enums.AppAndProductTypeEnum;
import com.pcloud.book.group.tools.SendWeixinRequestTools;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotWelcome;
import com.pcloud.book.pcloudkeyword.enums.WelcomeReplyTypeEnum;
import com.pcloud.book.push.dao.PersonalAppletsDao;
import com.pcloud.book.push.entity.PersonalApplets;
import com.pcloud.book.skill.dto.AppOrProductReplyDTO;
import com.pcloud.channelcenter.wechat.dto.AccountSettingDto;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.httpclient.UrlUtils;
import com.pcloud.contentcenter.resource.dto.ResourceDTO;
import com.pcloud.resourcecenter.product.dto.ProductDto;
import com.sdk.wxgroup.SendArticleMessageVO;
import com.sdk.wxgroup.WxGroupSDK;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("pcloudRobotSet")
public class PcloudRobotSet {

    @Autowired
    private ResourceConsr resourceConsr;
    @Autowired
    private ProductConsr productConsr;
    @Autowired
    private AppConsr appConsr;
    @Autowired
    private QrcodeSceneConsr qrcodeSceneConsr;
    @Autowired
    private WechatGroupConsr wechatGroupConsr;

    @Autowired
    private PersonalAppletsDao personalAppletsDao;

    @ParamLog("填充欢迎语回复")
    public void fillRobotWelcome(List<PcloudRobotWelcome> robotWelcomeList) {
        if(ListUtils.isEmpty(robotWelcomeList)){
            return;
        }
        List<Long> resourceIds=new ArrayList<>();
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)||WelcomeReplyTypeEnum.AUDIO.value.equals(type)){
                resourceIds.add(robotWelcome.getResourceId());
            }
        }
        Map<Long, ResourceDTO> resourceDTOMap=new HashMap<>();
        if (!ListUtils.isEmpty(resourceIds)){
            resourceDTOMap = resourceConsr.mapByIds(resourceIds);
        }
        for (PcloudRobotWelcome robotWelcome : robotWelcomeList){
            Integer type = robotWelcome.getReplyType();
            if (WelcomeReplyTypeEnum.RESOURCE.value.equals(type)||WelcomeReplyTypeEnum.AUDIO.value.equals(type)){
                ResourceDTO resourceDTO = resourceDTOMap.get(robotWelcome.getResourceId());
                if (resourceDTO != null){
                    robotWelcome.setResourceName(resourceDTO.getResourceName());
                    robotWelcome.setResourceUrl(resourceDTO.getFileUrl());
                    robotWelcome.setResourceTypeCode(resourceDTO.getTypeCode());
                    robotWelcome.setResourceTypeName(resourceDTO.getTypeName());
                    robotWelcome.setFileType(resourceDTO.getFileType());
                    robotWelcome.setFileSize(resourceDTO.getFileSize());
                    robotWelcome.setResourcePdfItems(resourceDTO.getResourcePdfItems());
                    robotWelcome.setResourceOfficeItemDTOs(resourceDTO.getResourceOfficeItemDTOs());
                }
            }
            if (WelcomeReplyTypeEnum.APPLETS.value.equals(type)){
                PersonalApplets byId = personalAppletsDao.getById(robotWelcome.getPersonalAppletsId());
                robotWelcome.setSlogan(byId.getSlogan());
                robotWelcome.setSloganImgUrl(byId.getSloganImgUrl());
            }
        }
    }
    public void sendAppOrProductReply(AppOrProductReplyDTO replyDTO) {
        AccountSettingDto accountSettingDto = null;
        String typeName = "";
        String picUrl = "";
        String title = "";
        String resultUrl = "";
        if (AppAndProductTypeEnum.APP.value.equals(replyDTO.getServeType())) {
            AppDto appDto = appConsr.getBaseById(replyDTO.getServeId());
            if (appDto != null) {
                accountSettingDto = qrcodeSceneConsr.getWechatInfo(appDto.getChannelId());
                typeName = appDto.getTypeName();
                picUrl = appDto.getSquareImg();
                title = appDto.getTitle();
            }
            if(accountSettingDto != null) {
                String endUrl = replyDTO.getLinkUrl() + "&wxId=" + replyDTO.getUserWxId() + "&robotWxId=" + replyDTO.getRobotWxId();
                String resultLinkUrl = SendWeixinRequestTools.splitUrl(accountSettingDto, endUrl);
                resultUrl = UrlUtils.getShortUrl4Own(resultLinkUrl);
            }
        }
        if (AppAndProductTypeEnum.PRODUCT.value.equals(replyDTO.getServeType())) {
            ProductDto productDto = productConsr.getProBaseById(replyDTO.getServeId());
            if (productDto != null) {
                typeName = productDto.getProductTypeDto() == null ? "" : productDto.getProductTypeDto().getTypeName();
                picUrl = productDto.getCoverImg();
                title = productDto.getProductName();
                resultUrl = UrlUtils.getShortUrl4Own(replyDTO.getLinkUrl() + "&wxId=" + replyDTO.getUserWxId() + "&robotWxId=" + replyDTO.getRobotWxId());
            }
        }
        if(!StringUtils.isEmpty(resultUrl)) {
            SendArticleMessageVO sendArticleMessageVO = new SendArticleMessageVO();
            sendArticleMessageVO.setCode(replyDTO.getSendMessageType());
            sendArticleMessageVO.setAltId(replyDTO.getRobotWxId());
            sendArticleMessageVO.setDescription(typeName);
            sendArticleMessageVO.setWxGroupId(replyDTO.getUserWxId());
            sendArticleMessageVO.setLinkUrl(resultUrl);
            sendArticleMessageVO.setPicUrl(picUrl);
            sendArticleMessageVO.setTitle(title);
            sendArticleMessageVO.setIp(replyDTO.getIp());
            sendArticleMessageVO.setCounts(replyDTO.getCounts());
            sendArticleMessageVO.setIndex(replyDTO.getIndex());
            sendArticleMessageVO.setMessageGroupId(replyDTO.getMessageGroupId());
            sendArticleMessageVO.setRobotProcessType(replyDTO.getRobotProcessTypeEnum());
            wechatGroupConsr.sendMessage(JSON.toJSONString(sendArticleMessageVO));
        }
    }

}
