package com.pcloud.book.personalstage.biz.impl;

import com.google.common.collect.Lists;

import com.pcloud.book.personalstage.dto.PersonalStageProgressDTO;
import com.pcloud.book.personalstage.entity.PersonalStageProgressMessage;
import com.pcloud.book.personalstage.dao.PersonalStageProgressMessageDao;
import com.pcloud.book.personalstage.biz.PersonalStageProgressMessageBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * (PersonalStageProgressMessage)表服务实现类
 *
 * @author zyq
 * @since 2020-02-25 09:56:00
 */
@Service("personalStageProgressMessageBiz")
public class PersonalStageProgressMessageBizImpl implements PersonalStageProgressMessageBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(PersonalStageProgressMessageBizImpl.class);

    @Autowired
    private PersonalStageProgressMessageDao personalStageProgressMessageDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public PersonalStageProgressMessage getById(Long id) {
        return personalStageProgressMessageDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public List<PersonalStageProgressMessage> getProgressMessageList(Integer progressId) {
        List<PersonalStageProgressMessage> progressMessageList = personalStageProgressMessageDao.getProgressMessageList(progressId);
        if (ListUtils.isEmpty(progressMessageList)){
            return Lists.newArrayList();
        }
        return progressMessageList;
    }

    @Override
    @ParamLog("保存")
    @Transactional(rollbackFor = Exception.class)
    public Long save(List<PersonalStageProgressMessage> personalStageProgressMessage) {
        if(ListUtils.isEmpty(personalStageProgressMessage)){
            throw BizException.PARAM_IS_NULL;
        }
        for(int i = personalStageProgressMessage.size()-1; i>=0; i--){
            if(personalStageProgressMessage.get(i).getType() == 2 && StringUtil.isEmpty(personalStageProgressMessage.get(i).getContent())){
                personalStageProgressMessage.remove(i);
            }
        }
        if(personalStageProgressMessage.stream().filter(x-> StringUtil.isEmpty(x.getContent())).count() > 0){
            throw BizException.PARAM_IS_NULL;
        }
        Integer progressId = personalStageProgressMessage.get(0).getProgressId();
        // 删除所有旧数据
        personalStageProgressMessageDao.deleteByProgressId(progressId);
        personalStageProgressMessage.stream().forEach(x->{
            if(x.getType() == null || x.getType() == 0){
                x.setType(1);
            }
        });
        // 重新插入
        return personalStageProgressMessageDao.insert(personalStageProgressMessage);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        personalStageProgressMessageDao.deleteById(id);
    }

    @Override
    public List<PersonalStageProgressDTO> getProgressList() {
        return personalStageProgressMessageDao.getProgressList();
    }
}