package com.pcloud.book.personalstage.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("定制化阶段跳转")
@Data
public class PersonalStageJump extends BaseEntity {

    @ApiModelProperty("定制化阶段id")
    private Long personalStageId;

    @ApiModelProperty("跳转类型：1读者输入关键词触发，2小睿发送关键词触发，3转账触发，4需求定制单触发")
    private Integer jumpType;

    @ApiModelProperty("跳转后阶段id")
    private Long afterPersonalStageId;

    @ApiModelProperty("是否开启邮件提醒")
    private Boolean openEmail;

    @ApiModelProperty("转账说明")
    private String transferMessage;

    @ApiModelProperty("转账金额")
    private Double transferMoney;

    @ApiModelProperty("距离阶段开始时间")
    private Integer toStageStartTime;

}