package com.pcloud.book.util.common;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolUtils {

    /**
     * 远程调用超时时间（单位：秒）
     */
    public static final int REMOTE_TIME_OUT = 5;


    /**
     * 异步导出线程池
     */
    public static final ExecutorService EXPORT_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("export-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 异步发送线程池
     */
    public static final ThreadPoolExecutor SEND_MESSAGE_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("send-message-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 异步导出线程池
     */
    public static final ExecutorService OTHER_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("other-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 入群邀请链接发送之前发送冒泡消息线程池
     */
    public static final ExecutorService SEND_MAOPAO_THREAD_POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("other-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 小程序小睿蹭光退出线程池
     */
    public static final ExecutorService SIGN_OUT_THREAD_POOL = new ThreadPoolExecutor(5, 5, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("sign-out-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 其他线程池
     */
    public static final ExecutorService OTHER_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("other-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 其他线程池
     */
    public static final ExecutorService SEND_NOTIFY_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("send-notify-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());


    public static final ExecutorService FILL_APPLET_RECORD = new ThreadPoolExecutor(8,8,0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("fill-applet-record-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());


    public static final ExecutorService RMALL_SIGN_IN = new ThreadPoolExecutor(8,8,0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("rmall_sign_in-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public static final ExecutorService APPLET_RECORD = new ThreadPoolExecutor(8,8,0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("applet_record-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public static final ExecutorService BOOK_READ_RECORD = new ThreadPoolExecutor(8,8,0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("book_read_record-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());


    public static final ExecutorService SMALL_THREAD_POOL = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("small-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    /**
     * 超级搜索更新线程
     */
    public static final ThreadPoolExecutor UPDATE_SUPER_SEARCH_POOL = new ThreadPoolExecutor(8, 8, 0, TimeUnit.SECONDS,
            new LinkedBlockingQueue<>(), new ThreadFactoryBuilder().setNameFormat("update_super_search-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());


}
