package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.AppClickDTO;
import com.pcloud.book.group.dto.AppStatisticsDTO;
import com.pcloud.book.group.dto.BookGroupAppDTO;
import com.pcloud.book.group.dto.BookGroupIdAndCountDTO;
import com.pcloud.book.group.dto.CountAndTimeDTO;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.book.group.vo.GroupScanTrendParamVO;
import com.pcloud.book.group.vo.GroupScanTrendVO;
import com.pcloud.book.group.vo.ResourceClickVO;
import com.pcloud.book.group.vo.ResourcesStatisticVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface AppClickRecordDao extends BaseDao<AppClickRecord> {
    /**
     * 根据作品或应用id集合获取统计
     */
    List<AppStatisticsDTO> getClickStatisticsByServeIds(List<Long> serveIds, Long qrcodeId, Long bookGroupId);

    /**
     * 获取最近点击
     */
    List<AppClickDTO> getRecentlyClick(Long wechatUserId, Long qrcodeId, Integer top);

    /**
     * 获取资源点击趋势
     */
    List<GroupScanTrendVO> getClickTrend(GroupScanTrendParamVO groupScanTrendParamVO);

    /**
     * 获取资源点击次数
     */
    Map<Long, ResourceClickVO> getResourceClick(Map<String,Object> map);

    /**
     * 获取资源点击总数
     */
    Long getRescourceTotalClick(Long bookGroupId,Long classifyId,Long qrcodeId,String type);

    /**
     * 获取资源id
     */
    List<Long> getRescourceIds(Long bookGroupId,Long classifyId,Long qrcodeId,String type);

    /**
     * 获取资源点击数
     */
    List<ResourcesStatisticVO> getClickStatistics(Long bookGroupId,Long classifyId,Long qrcodeId,String type);

    /**
     * 根据类型按照时间获取资源服务点击人数
     */
    List<CountAndTimeDTO> getAppClickByTime(Integer joinGroupType, Integer timeType, String startTime, String endTime);

    /**
     * 批量获取点击次数
     */
    List<BookGroupAppDTO> getClickCountByServe(Long bookGroupId, String serveType, List<Long> serveIds);

    /**
     * 批量获取点击人数
     */
    List<BookGroupAppDTO> getClickPeopleCountByServe(Long bookGroupId, String serveType, List<Long> serveIds);

    /**
     * 根据bookGroupId批量获取点击次数
     */
    List<CountAndTimeDTO> getAppClickByBookGroupId(Long bookGroupId, List<String> dateList);

    /**
     * 根据bookGroupIds获取应用点击人数
     */
    List<BookGroupIdAndCountDTO> getClPeCoByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 根据bookGroupIds获取应用点击人数
     */
    List<BookGroupIdAndCountDTO> getClCoByBookGroupIds(List<Long> bookGroupIds);
}
