package com.pcloud.book.keywords.biz;

import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.keywords.dto.KeywordDTO;
import com.pcloud.book.keywords.dto.KeywordStatisticsDTO;
import com.pcloud.book.keywords.dto.ReplyKeywordDTO;
import com.pcloud.book.keywords.dto.ServiceResourceDTO;
import com.pcloud.book.keywords.entity.BookKeyword;
import com.pcloud.book.keywords.vo.*;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.wechatgroup.message.dto.SendTextDTO;
import com.sdk.wxgroup.SendMessageTypeEnum;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/25 10:47
 */
public interface BookKeywordBiz {
    /**
     * @Author:lili
     * @Desr:新增关键词
     * @Date:2019/4/25 10:53
     */
    void insertKeyword(SetKeywordVO setKeywordVO);

    void insertKeywords(List<SetKeywordVO> setKeywordVOs, Long partyId);

    /**
     * @Author:lili
     * @Desr:更新关键词
     * @Date:2019/4/25 10:53
     */
    void updateKeyword(UpdateKeywordVO updateKeywordVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:删除关键词
     * @Date:2019/4/25 10:53
     */
    void deleteKeyword(DeleteKeywordVO deleteKeywordVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:设置排序值
     * @Date:2019/4/25 10:53
     */
    void setRank(SetRankVO setRankVO, Long partyId);

    /**
     * @Author:lili
     * @Desr:获取分类配置的关键词(为0标识查社群码配置关键词)
     * @Date:2019/4/25 10:54
     */
    PageBeanNew<ListKeywordVO> listKeywordsByClassify(ListKeywordParam listKeywordParam);

    /**
     * @Author:lili
     * @Desr:获取关键词基本信息
     * @Date:2019/4/25 14:36
     */
    KeywordVO getByBookKeyword(Long bookKeywordId);

    /**
     * @Author:lili
     * @Desr: 获取关键词(5个)（改成10个了）
     * @Date:2019/5/5 15:11
     */
    List<KeywordDTO> listFiveKeyword(Long classifyId, Long bookGroupId);

    /**
     * @Author:lili
     * @Desr: 回复关键词消息
     * @Date:2019/5/5 16:28
     */
    void sendKeywordMessage(SendTextDTO sendTextDTO);

    /**
     * 更新群人数
     * @param wxGroupId 微信群id
     * @param memberCount 群人数
     */
    void updateGroupPeopleCount(String wxGroupId, Integer memberCount, GroupClassifyQrcodeDTO classifyQrcodeInfo);

    /**
     * 修改群名称
     * @param weixinGroupId 微信群id
     * @param groupName 群名称
     * @param robotId 机器人id
     * @param ip ip地址
     */
    void checkGroupName(String weixinGroupId, String groupName, String robotId, String ip);

    /**
     * 关键词统计
     * @param currentPage
     * @param numPerPage
     * @param bookGroupId
     * @param weixinGroupId
     * @return
     */
    PageBeanNew<KeywordStatisticsDTO> getKeywordStatistics(Integer currentPage, Integer numPerPage, Long bookGroupId, String weixinGroupId);

    /**
    * @description 获取关键词个数
    * @author 戴兴
    * @date 2019/7/18 15:55
    */
    Integer getKeywordCount(Long bookGroupId, Long classifyId);
    /**
     * 获取某个群内关键词配置的所有资源
     * @param qrWeixinParam
     * @return
     */
    List<ServiceResourceDTO> getServiceByWeixinGroup(QrWeixinParam qrWeixinParam,Long classifyId, Long qrcodeId);
	
    ReplyKeywordDTO getReplyKeyword(String content, String weixinGroupId, String wexinGroupName);
	
    /**
     * 获取现代纸书的资源服务
     * @param qrWeixinParam
     * @return
     */
    List<ServiceResourceDTO> getServiceByChannel(QrWeixinParam qrWeixinParam, Long wechatUserId);

    /**
     * 根据社群码id获取关键词列表
     * @param bookGroupId
     * @return
     */
    List<KeywordDTO> getListByBookGroupId(Long bookGroupId);

    /**
     * 按照书处理暗号回复，推送资源
     */
    void dealByBookGroup(SendTextDTO sendTextDTO, Long bookGroupId, Boolean isPushUpdate);
}
