package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockRewardDao;
import com.pcloud.book.weixinclock.entity.WeixinClockReward;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 杨涛
 * @description TODO
 * @date 2019/8/15 14:04
 */
@Repository("weixinClockRewardDao")
public class WeixinClockRewardDaoImpl extends BaseDaoImpl<WeixinClockReward> implements WeixinClockRewardDao {

    @Override
    public void batchInsert(List<WeixinClockReward> weixinClockRewards) {
        super.sqlSessionTemplate.insert(getStatement("batchInsert"),weixinClockRewards);
    }

    @Override
    public List<WeixinClockReward> listRewardDetail4Adviser(Long weixinClockId) {
        return super.sqlSessionTemplate.selectList(getStatement("listRewardDetail4Adviser"),weixinClockId);
    }

    @Override
    public Integer getGrantNumFromReward(Long weixinClockId, Long clockDays) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("weixinClockId",weixinClockId);
        paramMap.put("clockDays",clockDays);
        return super.sqlSessionTemplate.selectOne(getStatement("getGrantNumFromReward"),paramMap);
    }

}
