package com.pcloud.book.applet.service;


import com.pcloud.book.applet.dto.AppletNewsVO;
import com.pcloud.common.dto.ResponseDto;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value = "pcloud-service-book", qualifier = "appletServiceCloud", path = "book/v1.0/appletService")
@Api(description = "小程序内部接口")
public interface AppletService {


    @ApiOperation("根据资讯id查资讯")
    @GetMapping("getNewsById")
    public ResponseEntity<ResponseDto<AppletNewsVO>> getNewsById(@RequestParam("newsId") Long newsId);
}
