package com.pcloud.book.book.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author lily
 * @date 2018/12/5 20:51
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookInfoAndAuthStatusDTO implements Serializable {

    @ApiModelProperty("图书标识")
    private Long bookId;

    @ApiModelProperty("图书名称")
    private String bookName;

    @ApiModelProperty("封面图")
    private String coverImg;

    @ApiModelProperty("图书状态")
    private Integer bookStatus;

    @ApiModelProperty("出版社")
    private String publish;

    @ApiModelProperty("是否删除")
    private Integer isDelete;

    @ApiModelProperty("书刊作者")
    private String author;

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public Integer getBookStatus() {
        return bookStatus;
    }

    public void setBookStatus(Integer bookStatus) {
        this.bookStatus = bookStatus;
    }

    public String getPublish() {
        return publish;
    }

    public void setPublish(String publish) {
        this.publish = publish;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String toString() {
        return "BookInfoAndAuthStatusDTO{" +
                "bookId=" + bookId +
                ", bookName='" + bookName + '\'' +
                ", coverImg='" + coverImg + '\'' +
                ", bookStatus=" + bookStatus +
                ", publish='" + publish + '\'' +
                ", isDelete=" + isDelete +
                '}';
    }
}
