package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.entity.AdvertisingWechatMsg;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：微信群消息
 * @作者：zhuyajie
 * @创建时间：15:24 2019/9/2
 * @版本：1.0
 */
public interface AdvertisingWechatMsgDao extends BaseDao<AdvertisingWechatMsg> {

    /**
    *根据广告位id查群消息
     */
    public List<AdvertisingWechatMsg> getByAdId(Long adId);

    /**
     * 删除广告位下群消息
     * @param adId
     */
    public void deleteByAdId(Long adId);

    /**
     * 根据广告位id集合查询
     */
    List<AdvertisingWechatMsg> getByAdIds(List<Long> adIds);
}
