package com.pcloud.book.advertising.dao.impl;

import java.util.List;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingAdviserPermissionDao;
import com.pcloud.book.advertising.entity.AdvertisingAdviserPermission;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位编辑书刊权限数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingAdviserPermissionDao")
public class AdvertisingAdviserPermissionDaoImpl extends BaseDaoImpl<AdvertisingAdviserPermission> implements AdvertisingAdviserPermissionDao {

    /**
     * 批量插入
     */
    @Override
    public long batchInsert(List<AdvertisingAdviserPermission> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    /**
     * 根据编辑ID删除
     */
    @Override
    public long deleteByAdviserId(Long adviserId) {
        return super.getSqlSession().delete(getStatement("deleteByAdviserId"), adviserId);
    }
}
