package com.pcloud.book.book.dao;

import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.entity.BookFreeze;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * 图书冻结数据访问层接口
 * 
 * @author lili
 * @date 2018/1/18 18:17
 */
public interface BookFreezeDao extends BaseDao<BookFreeze> {
	/**
	 * 获取
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	Boolean isFreeze(Long bookId);

	/**
	 * 获取图书的冻结状态
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	Map<Long, BookFreezeDto> getFreezeStatus(List<Long> bookIds);

	/**
	 * 获取冻结信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	BookFreezeDto getBaseById(Long bookId);

	/**
	 * 解冻收益(没有被基金购买)
	 * @param bookFundId
	 * 			图书期刊ID
	 * @param bookId
	 *            图书标识
	 * @param partyId
	 *            当事人标识
	 */
	void thaw(Long bookFundId,Long bookId, Long partyId);

	/**
	 * 获取图书是否被冻结
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	Map<Long, BookFreezeDto> getIsFreeze(List<Long> bookIds);

	/**
	 * 该书刊当前和以后基金冻结信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	List<BookFreezeDto> getFreezeInfo(Long bookId);

	/**
	 * 批量获取书刊当前和以后基金冻结信息
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	List<BookFreezeDto> listFreezeInfo(List<Long> bookIds);

	BookFreezeDto getInfoById(Long bookId);
}
