/**
 * 
 */
package com.pcloud.book.book.dao;

import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookTypeDto;
import com.pcloud.book.book.entity.BookType;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：
 * 
 * @作者：songx
 * @创建时间：2017年1月3日,下午3:08:47 @版本：1.0
 */
public interface BookTypeDao extends BaseDao<BookType> {

	/**
	 * 获取类型列表
	 * 
	 * @return
	 */
	public List<BookTypeDto> getList();

	/**
	 * 图书和期刊占比
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @return
	 */
	public List<BookTypeDto> getPercent4Type(Long adviserId);

	/**
	 * @Title: getCodeNameMap
	 * @Description:获取图书类型和Map
	 * @return: Map<String,String>
	 * @author: lihao
	 * @date: 2017年7月18日 下午6:27:38
	 */
	public Map<String, BookTypeDto> getTypeCodeMap();

}
