package com.pcloud.book.book.facade.impl;

import com.pcloud.book.book.biz.BookKeywordWarehouseBiz;
import com.pcloud.book.book.constant.BookConstant;
import com.pcloud.book.book.vo.BookKeywordProductVO;
import com.pcloud.book.book.vo.request.AddBookKeywordRequestVO;
import com.pcloud.book.book.vo.request.CheckKeywordRequestVO;
import com.pcloud.book.book.vo.request.EditBookKeywordRequestVO;
import com.pcloud.book.book.vo.request.QueryBookKeywordWarehouseRequestVO;
import com.pcloud.book.book.vo.response.BookKeywordResponseVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import javax.annotation.Resource;

import io.swagger.annotations.Api;

@Api("关键词库")
@RestController
@RequestMapping("keywordWarehouse")
public class BookKeywordWarehouseFacadeImpl {

    @Resource
    private BookKeywordWarehouseBiz bookKeywordWarehouseBiz;

    @PostMapping("addBookKeyword")
    public ResponseDto<Void> addBookKeyword(@RequestHeader("token") String token, @RequestBody AddBookKeywordRequestVO vo) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(adviserId);
        this.bookKeywordWarehouseBiz.addBookKeyword(vo, null);
        return new ResponseDto<>();
    }

    @PostMapping("editBookKeyword")
    public ResponseDto<Void> editBookKeyword(@RequestHeader("token") String token, @RequestBody EditBookKeywordRequestVO vo) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(adviserId);
        this.bookKeywordWarehouseBiz.editBookKeyword(vo);
        return new ResponseDto<>();
    }

    @GetMapping("deleteBookKeyword")
    public ResponseDto<Void> deleteBookKeyword(@RequestHeader("token") String token, @RequestParam("keywordId") Long keywordId) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        this.bookKeywordWarehouseBiz.deleteBookKeyword(keywordId, adviserId);
        return new ResponseDto<>();
    }

    @PostMapping("listBookKeywordWarehouse")
    public ResponseDto<PageBeanNew<BookKeywordResponseVO>> listBookKeywordWarehouse(@RequestHeader("token") String token, @RequestBody QueryBookKeywordWarehouseRequestVO vo) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        vo.setUserId(adviserId);
        final PageBeanNew<BookKeywordResponseVO> pageBeanNew = this.bookKeywordWarehouseBiz.listBookKeywordWarehouse(vo);
        return new ResponseDto<>(pageBeanNew);
    }

    @GetMapping("useKeyword")
    public ResponseDto<Void> useKeyword(@RequestHeader("token") String token, @RequestParam("keywordDetailId") Long keywordDetailId) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        this.bookKeywordWarehouseBiz.useKeyword(adviserId, keywordDetailId);
        return new ResponseDto<>();
    }

    @GetMapping("getDetail")
    public ResponseDto<BookKeywordResponseVO> getDetail(@RequestHeader("token") String token, @RequestParam("keywordId") Long keywordId) throws PermissionException {
        final BookKeywordResponseVO detail = this.bookKeywordWarehouseBiz.getDetail(keywordId);
        return new ResponseDto<>(detail);
    }

    @GetMapping("oftenKeyword")
    public ResponseDto<PageBeanNew<BookKeywordProductVO>> oftenKeyword(@RequestHeader("token") String token, @RequestParam("currentPage") Integer currentPage,
                                                                       @RequestParam("numPerPage") Integer numPerPage, @RequestParam("bookGroupId") Long bookGroupId,
                                                                       @RequestParam("depthLabelId") Long depthLabelId, @RequestParam("classifyId") Long classifyId) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        final PageBeanNew<BookKeywordProductVO> pageBeanNew = this.bookKeywordWarehouseBiz.oftenKeyword(currentPage, numPerPage, bookGroupId, adviserId, depthLabelId, classifyId);
        return new ResponseDto<>(pageBeanNew);
    }

    @GetMapping("hotKeyword")
    public ResponseDto<PageBeanNew<BookKeywordProductVO>> hotKeyword(@RequestHeader("token") String token, @RequestParam("currentPage") Integer currentPage,
                                                                     @RequestParam("numPerPage") Integer numPerPage, @RequestParam("bookGroupId") Long bookGroupId,
                                                                     @RequestParam(value = "keyword", required = false) String keyword,
                                                                     @RequestParam(value = "depthLabelId", required = false) Long depthLabelId, @RequestParam("classifyId") Long classifyId,
                                                                     @RequestParam(value = "isForAdviser", required = false) Boolean isForAdviser) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        final PageBeanNew<BookKeywordProductVO> pageBeanNew = this.bookKeywordWarehouseBiz.hotKeyword(currentPage, numPerPage, adviserId, bookGroupId, keyword, depthLabelId, classifyId, isForAdviser);
        return new ResponseDto<>(pageBeanNew);
    }

    @GetMapping("auditKeyword")
    public ResponseDto<Void> auditKeyword(@RequestHeader("token") String token, @RequestParam("keywordId") Long keywordId, @RequestParam("auditCode") Integer auditCode) throws PermissionException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        this.bookKeywordWarehouseBiz.auditKeyword(adviserId, keywordId, BookConstant.AUDIT_ENUM_MAP.get(auditCode));
        return new ResponseDto<>();
    }

    @PostMapping("checkKeyword")
    public ResponseDto<List<Long>> checkKeyword(@RequestHeader("token") String token, @RequestBody CheckKeywordRequestVO vo) throws PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        final List<Long> code = this.bookKeywordWarehouseBiz.checkKeyword(vo);
        return new ResponseDto<>(code);
    }

}
