package com.pcloud.book.cultivate.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.wechatgroup.selfrobot.dto.RobotAndFriendInfoDTO;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;

import lombok.Data;

/**
 *小程序用户
 */
@Data
public class SendUserDetailDto implements Serializable{
	private static final long serialVersionUID = 3666718926619191804L;
	
    private Long wechatUserId;

    private String wxId;

    /**
     * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
     */
    private Integer sex;

    private String headUrl;

    private String phoneNumber;

    private Date createTime;

    //是否加小睿好友
    private Boolean isSelfFriend;

    //小睿好友列表
    private List<RobotAndFriendInfoDTO> robotInfoList;

    @JSONField(
            format = "yyyy-MM-dd HH:mm:ss"
    )
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @XmlElement
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
