package com.pcloud.book.cultivate.enums;

public enum CultivateSkillTypeEnum {

    /**
     * 打招呼
     */
    SAY_HI(1,"打招呼"),
    /**
     * 唱歌
     */
    SING(2,"唱歌"),
    /**
     * 爱读书
     */
    READ(3,"爱读书");

    public final Integer code;

    public final String name;

    CultivateSkillTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(Integer code) {
        if (code==null) {
            return null;
        }
        CultivateSkillTypeEnum[] all = values();
        int length = all.length;
        for (int i = 0; i < length; ++i) {
            CultivateSkillTypeEnum cultivateSkillTypeEnum = all[i];
            if (cultivateSkillTypeEnum.code.equals(code)) {
                return cultivateSkillTypeEnum.name;
            }
        }
        return null;
    }

}
