package com.pcloud.book.custom.enums;

import java.util.Arrays;

public enum PlanReadTypeEnum {
    RELAX(1, "轻松阅读"),
    EFFICIENT(2,"高效阅读"),
    DEPTH(3,"深度阅读");

    public final Integer id;
    public final String desc;

    PlanReadTypeEnum(Integer id, String desc){
        this.id = id;
        this.desc = desc;
    }

    public static Integer getIdByDesc(String desc){
        return Arrays.stream(PlanReadTypeEnum.values()).filter(x->x.desc.equals(desc)).map(x->x.id).findFirst().orElse(null);
    }

    public static String getDescById(Integer id){
        return Arrays.stream(PlanReadTypeEnum.values()).filter(x->x.id.equals(id)).map(x->x.desc).findFirst().orElse(null);
    }

}
