package com.pcloud.book.giftcoupon.dao.impl;

import com.pcloud.book.giftcoupon.dao.GiftReceiveDao;
import com.pcloud.book.giftcoupon.dto.GiftReceiveDTO;
import com.pcloud.book.giftcoupon.entity.GiftReceive;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("giftReceiveDao")
public class GiftReceiveDaoImpl extends BaseDaoImpl<GiftReceive> implements GiftReceiveDao {

    @Override
    public GiftReceive getGiftReceive(Long wechatUserId, Long giftPackageId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("giftPackageId",giftPackageId);
        return super.getSessionTemplate().selectOne(getStatement("getGiftReceive"),map);
    }



    @Override
    public void useGiftCoupon(Long wechatUserId, Long giftPackageId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("giftPackageId",giftPackageId);
        super.getSessionTemplate().update(getStatement("useGiftCoupon"),map);
    }

    @Override
    public List<GiftReceiveDTO> getGiftReceiveNumList(List<Long> giftPackageIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("giftPackageIds",giftPackageIds);
        return super.getSessionTemplate().selectList(getStatement("getGiftReceiveNumList"),map);
    }

    @Override
    public List<Long> getUserReceiveGiftId(Long wechatUserId) {
        return super.getSessionTemplate().selectList(getStatement("getUserReceiveGiftId"),wechatUserId);
    }

    @Override
    public Map<Long, GiftReceive> getMapByIds(List<Long> giftPackageIds,Long wechatUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("giftPackageIds",giftPackageIds);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectMap(super.getStatement("getMapByIds"), map, "gift_package_id");
    }

    @Override
    public void updateReceiveNum(List<Long> receives) {
        Map<String,Object> map=new HashMap<>();
        map.put("receives",receives);
        super.getSessionTemplate().update(getStatement("updateReceiveNum"),map);
    }
}
