package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.WxUserWechatRelevanceDao;
import com.pcloud.book.group.entity.WxUserWechatRelevance;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/16 15:46
 **/
@Component("wxUserWechatRelevanceDao")
public class WxUserWechatRelevanceDaoImpl extends BaseDaoImpl<WxUserWechatRelevance> implements WxUserWechatRelevanceDao {
    @Override
    public void updateWxIdByRandomCode(String randomCode, String wxId) {
        Map<String, Object> map = new HashMap<>();
        map.put("randomCode", randomCode);
        map.put("wxId", wxId);
        this.getSqlSession().update(this.getStatement("updateWxIdByRandomCode"), map);
    }

    @Override
    public WxUserWechatRelevance getByWechatUserId(Long wechatUserId) {
        return this.getSqlSession().selectOne(this.getStatement("getByWechatUserId"), wechatUserId);
    }

    @Override
    public WxUserWechatRelevance getByRandomCode(String randomCode) {
        return this.getSqlSession().selectOne(this.getStatement("getByRandomCode"), randomCode);
    }
}
