package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lily
 * @date 2019/5/6 16:08
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GroupQrcodeBaseInfoVO implements Serializable {

    @ApiModelProperty("群标识")
    private Long groupQrcodeId;

    @ApiModelProperty("群名称")
    private String groupName;

    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

    @ApiModelProperty(value = "二维码地址", hidden = true)
    private String weixinGroupId;

    @ApiModelProperty(value = "当前群人数", hidden = true)
    private Integer userNumber;

}
