package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.keywords.dao.BookGuideDao;
import com.pcloud.book.keywords.dto.GuideDTO;
import com.pcloud.book.keywords.entity.BookGuide;
import com.pcloud.book.keywords.vo.GuideVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/23 15:54
 */
@Component("bookGuideDao")
public class BookGuideDaoImpl extends BaseDaoImpl<BookGuide> implements BookGuideDao {
    @Override
    public GuideVO getGuideByBookGroup(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getGuideByBookGroup"), bookGroupId);
    }

    @Override
    public GuideVO getGuideByClassify(Long classifyId) {
        return this.getSqlSession().selectOne(this.getStatement("getGuideByClassify"), classifyId);
    }

    @Override
    public GuideDTO getBaseInfo(Long classifyId, Long bookGroupId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("classifyId", classifyId);
        paramMap.put("bookGroupId", bookGroupId);
        return this.getSqlSession().selectOne(this.getStatement("getBaseInfo"), paramMap);
    }

    @Override
    public List<BookGroupApp> getAllAppGuide() {
        return this.getSqlSession().selectList(this.getStatement("getAllAppGuide"));
    }
}
