package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.BookKeywordRecordDao;
import com.pcloud.book.keywords.dto.KeywordStatisticsDTO;
import com.pcloud.book.keywords.dto.KeywordUserCountDTO;
import com.pcloud.book.keywords.entity.BookKeywordRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/5/9 16:23
 */
@Component("bookKeywordRecordDao")
public class BookKeywordRecordDaoImpl extends BaseDaoImpl<BookKeywordRecord> implements BookKeywordRecordDao {
    @Override
    public Map<Long, KeywordUserCountDTO> listKeywordUseCount(List<Long> qrcodeIds) {
        return this.getSqlSession().selectMap(this.getStatement("listKeywordUseCount"), qrcodeIds, "qrcodeId");
    }

    @Override
    public List<KeywordStatisticsDTO> getKeywordStatistics(Long bookGroupId, String weixinGroupId, List<Long> keywordIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("bookGroupId",bookGroupId);
        map.put("weixinGroupId",weixinGroupId);
        map.put("keywordIds",keywordIds);
        return this.getSqlSession().selectList(this.getStatement("getKeywordStatistics"), map);
    }

    @Override
    public List<KeywordStatisticsDTO> getKeywordStatisticsByTime(Long bookGroupId, String weixinGroupId, List<Long> keywordIds, Date startDate) {
        Map<String,Object> map=new HashMap<>();
        map.put("bookGroupId",bookGroupId);
        map.put("weixinGroupId",weixinGroupId);
        map.put("keywordIds",keywordIds);
        map.put("startDate",startDate);
        return this.getSqlSession().selectList(this.getStatement("getKeywordStatisticsByTime"), map);
    }
}
