package com.pcloud.book.keywords.facade.impl;

import com.pcloud.book.keywords.biz.BookGuideBiz;
import com.pcloud.book.keywords.facade.BookGuideFacade;
import com.pcloud.book.keywords.vo.GuideVO;
import com.pcloud.book.keywords.vo.ReplyMessageVO;
import com.pcloud.book.keywords.vo.SetGuideVO;
import com.pcloud.book.keywords.vo.UpdateGuideVO;
import com.pcloud.common.core.constant.MQTopicProducer;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.wechatgroup.message.dto.AgreeAddUserDTO;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @author lily
 * @date 2019/4/23 15:24
 */
@Slf4j
@RestController("bookGuideFacade")
@RequestMapping("bookGuide")
public class BookGuideFacadeImpl implements BookGuideFacade {

    @Autowired
    private BookGuideBiz bookGuidBiz;
    @Autowired
    private AmqpTemplate amqpTemplate;

    @PostMapping("test")
    public void test() {
        final AgreeAddUserDTO agreeAddUserDTO = new AgreeAddUserDTO();
        agreeAddUserDTO.setNickName("大威");
        agreeAddUserDTO.setRobotWxId("wxid_arjobo1bbk2i22");
        // 当消息为个人消息时，wechatGroupId为发送人id
        agreeAddUserDTO.setUserWxId("p867263500");
        agreeAddUserDTO.setIp("http://192.168.92.122:8081");
        log.info("[processSelfMessage] start convertAndSend agreeAddUserDTO:{}", agreeAddUserDTO);
        // 发送topic book处理后续欢迎语，关键词和拉群操作
        amqpTemplate.convertAndSend(MQTopicProducer.EXCHAGE, MQTopicProducer.WX_AGREE_ADD_USER, agreeAddUserDTO);
    }

    @Override
    @PostMapping("insertGuide")
    public ResponseDto<?> insertGuide(@RequestHeader("token") String token, @RequestBody SetGuideVO setGuideVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGuidBiz.insertGuide(setGuideVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateGuide")
    public ResponseDto<?> updateGuide(@RequestHeader("token") String token, @RequestBody UpdateGuideVO updateGuideVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGuidBiz.updateGuide(updateGuideVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getGuideByBookGroup")
    public ResponseDto<GuideVO> getGuideByBookGroup(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) throws BizException, PermissionException {
        GuideVO guideVO =  bookGuidBiz.getGuideByBookGroup(bookGroupId);
        return new ResponseDto<>(guideVO == null ? new GuideVO() : guideVO);
    }

    @Override
    @GetMapping("getGuideByClassify")
    public ResponseDto<GuideVO> getGuideByClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        GuideVO guideVO =  bookGuidBiz.getGuideByClassify(classifyId);
        return new ResponseDto<>(guideVO == null ? new GuideVO() : guideVO);
    }

    @Override
    @RequestMapping(value = "getGuideMessage", method = RequestMethod.GET)
    public ResponseDto<Map<String, Object>> getGuideMessage(@RequestParam(value = "weixinGroupId", required = false) String weixinGroupId, @RequestParam(value = "wexinGroupName", required = false) String wexinGroupName) {
        Map<String, Object> resultMap = bookGuidBiz.getGuideMessage(weixinGroupId, wexinGroupName);
        return new ResponseDto<>(resultMap);
    }
}
