package com.pcloud.book.mq.topic;

import com.pcloud.book.consumer.message.TemplateConsr;
import com.pcloud.book.group.dao.BookGroupDao;
import com.pcloud.book.group.dao.BookGroupServeDao;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.enums.JoinGroupTypeEnum;
import com.pcloud.book.keywords.dao.BookKeywordDao;
import com.pcloud.book.keywords.dao.SelfRobotKeywordDao;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.SceneCode;
import com.pcloud.common.core.constant.SendType;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.exceptions.BizException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description社群码扫码人数达到一定数量
 * @Author ruansiyuan
 * @Date 2019/12/5 16:34
 **/
@Component("someUserScanBookGroupListener")
@RabbitListener(queues = MQTopicConumer.CONSUMER_SOME_USER_SCAN_BOOK_GROUP)
public class SomeUserScanBookGroupListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(SomeUserScanBookGroupListener.class);
    @Autowired
    private BookGroupDao bookGroupDao;
    @Autowired
    private BookKeywordDao bookKeywordDao;
    @Autowired
    private BookGroupServeDao bookGroupServeDao;
    @Autowired
    private TemplateConsr templateConsr;
    @Autowired
    private SelfRobotKeywordDao selfRobotKeywordDao;

    @ParamLog("接收社群码扫码人数达到一定数量topic")
    @RabbitHandler
    public void onMessage(Long bookGroupId) throws BizException {
        if (bookGroupId == null) {
            return;
        }
        BookGroupDTO dto = bookGroupDao.getDTOById(bookGroupId);
        if (dto == null) {
            LOGGER.error("没有找到该社群码" + bookGroupId);
            return;
        }
        Integer joinGroupType = dto.getJoinGroupType();
        Boolean isSend = false;
        if (JoinGroupTypeEnum.GROUP_QRCODE.getCode().equals(joinGroupType)) {
            //普通群查询有没有配置关键词
            Integer keywordCount = bookKeywordDao.getKeywordCount(bookGroupId, null);
            if (keywordCount <= 0) {
                isSend = true;
            }
        }
        if (JoinGroupTypeEnum.ROBOT.getCode().equals(joinGroupType)) {
            //1v1查询有没有配置资源服务
            Integer count = bookGroupServeDao.getCountByBookGroupId(bookGroupId);
            if (count <= 0) {
                isSend = true;
            }
        }
        if (JoinGroupTypeEnum.AI_ROBOT.getCode().equals(joinGroupType)) {
            //1v1查询有没有配置资源服务
            Integer count = selfRobotKeywordDao.getCountByBookGroupId(bookGroupId);
            if (count <= 0) {
                isSend = true;
            }
        }
        if (isSend) {
            //发送模板消息
            sendTemplate(dto);
        }
    }

    @ParamLog("发送模板消息")
    private void sendTemplate(BookGroupDTO dto) {
        try {
            Map<String, String> temParam = new HashMap<>();
            String word="已有读者扫码！您的二维码“" + dto.getGroupQrcodeName() + "”还未配置任何资源服务。请及时完善该二维码资源服务。";
            temParam.put("first", word);
            temParam.put("keyword1", "【提醒】您的二维码还未配置资源服务");
            temParam.put("keyword2", "请前往编辑端为二维码配置相关资源或服务");
            temParam.put("remark", "请及时处理");
            templateConsr.sendManage(SceneCode.PROJECT_TASK_SCENE.value, dto.getAgentId(), dto.getCreateUser(),
                    SystemCode.adviser.code, "", temParam, SendType.SEND_BY_PARTY_ID.value, false);
            LOGGER.info("资源未配置发送模板消息temParam="+temParam.toString()+"dto="+dto.toString());
        } catch (Exception e) {
            LOGGER.error("编辑管理--删除副编辑,发送模板消息失败<ERROR>" + e.getMessage());
        }
    }

}
