package com.pcloud.book.pcloudkeyword.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.pcloudkeyword.biz.PcloudKeywordBiz;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeyword;
import com.pcloud.book.pcloudkeyword.entity.PcloudNotKeyword;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.book.pcloudkeyword.biz.PcloudKeywordClassifyBiz;
import com.pcloud.book.pcloudkeyword.dto.PcloudKeywordClassifyDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordClassify;
import com.pcloud.common.utils.string.StringUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;

import java.util.List;

@Api("全平台关键词")
@RestController("pcloudKeywordFacade")
@RequestMapping("pcloudKeyword")
public class PcloudKeywordFacade {

    @Autowired
    private PcloudKeywordBiz pcloudKeywordBiz;
    @Autowired
    private PcloudKeywordClassifyBiz pcloudKeywordClassifyBiz;


    @ApiOperation("新增关键词分类")
    @PostMapping("insertClassify")
    public ResponseDto<?> insertClassify(@RequestHeader("token") String token, @RequestBody @ApiParam PcloudKeywordClassify pcloudKeywordClassify) throws PermissionException {
       Long partyId = (Long) SessionUtil.getVlaue(token,SessionUtil.PARTY_ID);
       if (null == pcloudKeywordClassify || StringUtil.isEmpty(pcloudKeywordClassify.getKeywordClassify()) || null == pcloudKeywordClassify.getOpen()){
           throw new BookBizException(BookBizException.FILED_NULL,"缺少参数");
       }
       pcloudKeywordClassify.setCreateUser(partyId);
       return new ResponseDto<>(pcloudKeywordClassifyBiz.insert(pcloudKeywordClassify));
    }

    @ApiOperation("修改关键词分类")
    @PostMapping("updateClassify")
    public ResponseDto<?> updateClassify(@RequestHeader("token") String token, @RequestBody @ApiParam PcloudKeywordClassify pcloudKeywordClassify) throws PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token,SessionUtil.PARTY_ID);
        if (null == pcloudKeywordClassify || null == pcloudKeywordClassify.getId()){
            throw new BookBizException(BookBizException.FILED_NULL,"缺少参数id");
        }
        if (StringUtil.isEmpty(pcloudKeywordClassify.getKeywordClassify()) || null == pcloudKeywordClassify.getOpen()){
            throw new BookBizException(BookBizException.FILED_NULL,"缺少参数");
        }
        pcloudKeywordClassify.setUpdateUser(partyId);
        pcloudKeywordClassifyBiz.update(pcloudKeywordClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("删除关键词分类")
    @GetMapping("deleteClassifyById")
    public ResponseDto<?> deleteClassifyById(@RequestHeader("token") String token, @RequestParam("id") @ApiParam("id")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == id){
            throw new BookBizException(BookBizException.FILED_NULL,"缺少参数id");
        }
        pcloudKeywordClassifyBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("修改关键词分类启用状态")
    @GetMapping("updateClassifyOpen")
    public ResponseDto<?> updateClassifyOpen(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("id") Long id, @RequestParam("open") @ApiParam("启用状态") Boolean open) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == id || null == open){
            throw new BookBizException(BookBizException.FILED_NULL,"缺少参数");
        }
        pcloudKeywordClassifyBiz.updateOpenStateById(id, open);
        return new ResponseDto<>();
    }

    @ApiOperation("关键词分类列表")
    @GetMapping("listKeywordClassify")
    public ResponseDto<List<PcloudKeywordClassifyDTO>> listKeywordClassify(
            @RequestHeader("token") String token,
            @RequestParam(value = "classify", required = false) @ApiParam("分类名模糊查询") String classify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        List<PcloudKeywordClassifyDTO> list = pcloudKeywordClassifyBiz.list(classify);
        return new ResponseDto<>(list);
    }

    @ApiOperation("新增平台端关键词")
    @PostMapping("createPcloudKeyword")
    ResponseDto<?> createPcloudKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("平台端关键词") PcloudKeyword pcloudKeyword
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudKeywordBiz.createPcloudKeyword(pcloudKeyword);
        return new ResponseDto<>();
    }

    @ApiOperation("修改平台端关键词")
    @PostMapping("updatePcloudKeyword")
    ResponseDto<?> updatePcloudKeyword(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("平台端关键词") PcloudKeyword pcloudKeyword
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudKeywordBiz.updatePcloudKeyword(pcloudKeyword);
        return new ResponseDto<>();
    }

    @ApiOperation("获取平台端关键词")
    @GetMapping("getPcloudKeyword")
    ResponseDto<?> getPcloudKeyword(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("平台端关键词") Long id
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudKeywordBiz.getPcloudKeyword(id));
    }

    @ApiOperation("获取平台端关键词")
    @GetMapping("getPcloudKeywordList")
    ResponseDto<?> getPcloudKeywordList(
            @RequestHeader("token") String token,
            @RequestParam("keywordClassifyId") @ApiParam("平台端关键词分类id") Long keywordClassifyId,
            @RequestParam(value = "name", required = false) @ApiParam("平台端关键词名称") String name,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudKeywordBiz.getPcloudKeywordList(keywordClassifyId, name, currentPage,numPerPage));
    }

    @ApiOperation("删除平台端关键词")
    @GetMapping("deletePcloudKeyword")
    ResponseDto<?> deletePcloudKeyword(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("平台端关键词") Long id
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudKeywordBiz.deletePcloudKeyword(id);
        return new ResponseDto<>();
    }

    @ApiOperation("新增非关键词")
    @PostMapping("insertNotKeyword")
    public ResponseDto<?> insertNotKeyword(@RequestHeader("token") String token, @RequestBody @ApiParam PcloudNotKeyword pcloudNotKeyword) throws PermissionException {
          Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
          pcloudNotKeyword.setCreateUser(partyId);
          Long id = pcloudKeywordBiz.insertNotKeyword(pcloudNotKeyword);
          return new ResponseDto<>(id);
    }

    @ApiOperation("修改非关键词")
    @PostMapping("updateNotKeyword")
    public ResponseDto<?> updateNotKeyword(@RequestHeader("token") String token, @RequestBody @ApiParam PcloudNotKeyword pcloudNotKeyword) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        pcloudKeywordBiz.updateNotKeyword(pcloudNotKeyword);
        return new ResponseDto<>();
    }

    @ApiOperation("删除非关键词")
    @GetMapping("deleteNotKeywordById")
    public ResponseDto<?> deleteNotKeywordById(@RequestHeader("token") String token,@RequestParam("id") Long id) throws PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudKeywordBiz.deletePcloudNotKeyword(id);
        return new ResponseDto<>();
    }

    @ApiOperation("根据id查询非关键词")
    @GetMapping("getNotKeywordById")
    public ResponseDto<?> getNotKeywordById(@RequestHeader("token") String token,@RequestParam("id") Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        return new ResponseDto<>(pcloudKeywordBiz.getNotKeywordById(id));
    }

    @ApiOperation("获取平台端非关键词")
    @GetMapping("getPcloudNotKeywordList")
    ResponseDto<?> getPcloudNotKeywordList(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("平台端关键词分类id") Long keywordClassifyId,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage
    ) throws BizException, PermissionException{
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudKeywordBiz.getPcloudNotKeywordList(keywordClassifyId, currentPage,numPerPage));
    }

    @ApiOperation("根据小号分类获取平台端关键词分类")
    @GetMapping("getKeywordClassifyByRobotClassifyId")
    public ResponseDto<?> getKeywordClassifyByRobotClassifyId(@RequestHeader("token")String token, @RequestParam("robotClassifyId") Long robotClassifyId) throws PermissionException {
         SessionUtil.getInfoToken4Redis(token);
        PcloudKeywordClassify classify = pcloudKeywordClassifyBiz.getKeywordClassifyByRobotClassifyId(robotClassifyId);
        return new ResponseDto<>(classify);
    }
}
