package com.pcloud.book.personalstage.dao;

import com.pcloud.book.personalstage.dto.PersonalStageJumpDto;
import com.pcloud.book.personalstage.entity.PersonalStageJump;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface PersonalStageJumpDao extends BaseDao<PersonalStageJump> {

    Integer getCountByPersonalStageId(Long personalStageId);
    PersonalStageJumpDto getDtoById(Long jumpId);

    /**
     * 根据跳转类型获取阶段跳转
     * @return
     */
    List<PersonalStageJump> getByJumpType(Long personalStageId, Integer jumpType);
}