package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageReplyDao;
import com.pcloud.book.personalstage.entity.PersonalStageReply;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("personalStageReply")
public class PersonalStageReplyDaoImpl extends BaseDaoImpl<PersonalStageReply> implements PersonalStageReplyDao {

    @Override
    public Integer batchInsert(List<PersonalStageReply> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<Long> getIdsByPersonalStageId(Long personalStageId) {
        return super.getSqlSession().selectList(getStatement("getIdsByPersonalStageId"), personalStageId);
    }

    @Override
    public void deleteByIds(List<Long> list) {
        super.getSqlSession().delete(getStatement("deleteByIds"), list);
    }

    @Override
    public List<PersonalStageReply> getListByPersonalStageId(Long personalStageId) {
        return super.getSqlSession().selectList(getStatement("getListByPersonalStageId"), personalStageId);
    }

    @Override
    public List<Long> getIdsByRelevance(Integer relevanceType, Long relevanceId) {
        Map<String, Object> map = new HashMap<>();
        map.put("relevanceType", relevanceType);
        map.put("relevanceId", relevanceId);
        return super.getSessionTemplate().selectList(getStatement("getIdsByRelevance"), map);
    }

    @Override
    public PersonalStageReply personalStageReply4Order(Integer relevanceType, Long personalStageId, Integer count) {
        Map<String, Object> map = new HashMap<>();
        map.put("relevanceType", relevanceType);
        map.put("relevanceId", personalStageId);
        map.put("count", count);
        return super.getSessionTemplate().selectOne(getStatement("personalStageReply4Order"), map);
    }
}
