package com.pcloud.book.personalstage.dao.impl;

import com.pcloud.book.personalstage.dao.PersonalStageReplyItemDao;
import com.pcloud.book.personalstage.entity.PersonalStageReplyItem;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("personalStageReplyItem")
public class PersonalStageReplyItemDaoImpl extends BaseDaoImpl<PersonalStageReplyItem> implements PersonalStageReplyItemDao {

    @Override
    public Integer batchInsert(List<PersonalStageReplyItem> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }
    @Override
    public void deleteByReplyIds(List<Long> list) {
        super.getSqlSession().delete(getStatement("deleteByReplyIds"), list);
    }

    @Override
    public List<PersonalStageReplyItem> getListByReplyIds(List<Long> list) {
        return super.getSqlSession().selectList(getStatement("getListByReplyIds"), list);
    }
}
