package com.pcloud.book.reading.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel("共读活动基本设置")
public class ReadingActivity extends BaseEntity {

    @ApiModelProperty("活动主题")
    private String theme;

    @ApiModelProperty("品牌方id")
    private Long brandId;

    @ApiModelProperty("入群条件（1无限制2回复关键词3转账）")
    private Integer joinCondition;

    @ApiModelProperty("入群关键词")
    private String joinKeyword;

    @ApiModelProperty("入群转账金额")
    private BigDecimal joinAmount;

    @ApiModelProperty("入群方式（link/qrcode）")
    private Integer joinType;

    @ApiModelProperty("入群二维码图片")
    private String joinQrcodePic;

    @ApiModelProperty("群规类型（1文本2文件）")
    private Integer ruleType;

    @ApiModelProperty("群规")
    private String rule;

    @ApiModelProperty("群规文件资源id")
    private String ruleResourceId;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("开场语类型（1文本2文件）")
    private Integer startSloganType;

    @ApiModelProperty("开场语")
    private String startSlogan;

    @ApiModelProperty("开场语资源id")
    private String startResourceId;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("结束语（1文本2文件）")
    private Integer endSloganType;

    @ApiModelProperty("结束语")
    private String endSlogan;

    @ApiModelProperty("结束语资源id")
    private String endResourceId;

    @ApiModelProperty("猜谜语开启状态")
    private Boolean riddleOpen;

    @ApiModelProperty("奖励开启")
    private Boolean awardOpen;

    @ApiModelProperty("奖励文案")
    private String awardText;

    @ApiModelProperty("奖励图片地址")
    private String awardPic;

    @ApiModelProperty("打卡开启")
    private Boolean clockOpen;

    @ApiModelProperty("打卡每日提醒时间")
    private String clockRemindTime;

    @ApiModelProperty("打卡提醒内容")
    private String clockRemindContent;

    @ApiModelProperty("打卡链接")
    private String clockLink;

    @ApiModelProperty("打卡商品或作品id")
    private Long clockServeId;

    @ApiModelProperty("打卡应用或作品")
    private String clockServeType;

    @ApiModelProperty("打卡成果是否发送")
    private Boolean clockResultOpen;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;




}