package com.pcloud.book.riddle.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.pcloud.book.riddle.RiddleService;
import com.pcloud.book.riddle.biz.RiddleRecordBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @描述：猜谜语
 * @作者：zhuyajie
 * @创建时间：16:26 2019/8/5
 * @版本：1.0
 */
@RestController("riddleService")
@RequestMapping("riddleService")
public class RiddleServiceImpl implements RiddleService {

    @Autowired
    private RiddleRecordBiz riddleRecordBiz;

    @RequestMapping(value = "/riddleEndQuartz", method = RequestMethod.POST)
    @Override
    @ParamLog("定时器调用游戏结束接口")
    public void riddleEndQuartz(@RequestBody Map<String, Object> map) {
        String wxGroupId = JSON.parseObject(JSON.toJSONString(map.get("wxGroupId")), new TypeReference<String>() {});
        String wxId = JSON.parseObject(JSON.toJSONString(map.get("wxId")), new TypeReference<String>() {});
        String ip = JSON.parseObject(JSON.toJSONString(map.get("ip")), new TypeReference<String>() {});
        String wxUserId = JSON.parseObject(JSON.toJSONString(map.get("wxUserId")), new TypeReference<String>() {});
        if (StringUtil.isEmpty(wxGroupId)) {
            return;
        }
        riddleRecordBiz.autoEnd(wxGroupId, wxId, ip, wxUserId);
    }
}
